% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_obj_from_dicom.R
\name{load.obj.from.dicom}
\alias{load.obj.from.dicom}
\title{Loading an \pkg{espadon} object from DICOM files or folder}
\usage{
load.obj.from.dicom(
  dcm.files,
  data = TRUE,
  ref.pseudo = "ref1",
  tag.dictionary = dicom.tag.dictionary(),
  verbose = TRUE
)
}
\arguments{
\item{dcm.files}{String vector, representing the list of the full names of the
DICOM files of the same DICOM object, or its directory.}

\item{data}{Boolean. Only valid for objects usable by the \pkg{espadon} package,
namely ct, mr, rtdose, rtstruct, pt... If \code{data = TRUE}, either the values
of the voxels when modality is (ct, mr, rtdose, pt), or the coordinates of the
RoI when modality is rtstruct, are loaded into memory.}

\item{ref.pseudo}{String, \code{$ref.pseudo} (i.e. pseudonym of the frame of
reference)
to assign to the loaded object.}

\item{tag.dictionary}{Dataframe, by default equal to
\link[espadon]{dicom.tag.dictionary},
whose structure it must keep. This dataframe is used to parse DICOM files.}

\item{verbose}{Boolean. If \code{TRUE}, a progress bar indicates the progress
of the conversion.}
}
\value{
Returns an \pkg{espadon} object of class "dvh","histo","histo2D","mesh",
"rtplan","struct", "undef" or "volume" depending on the object modality. See
\link[espadon]{espadon.class} for class definitions.
}
\description{
Loading an \pkg{espadon} object from DICOM files or folder.
}
\examples{
# First, save toy.dicom.raw () raw data to a temporary file pat.dir for testing.
pat.dir <- file.path (tempdir(), "PM_dcm") 
dir.create (pat.dir, recursive = TRUE) 
dcm.filename <- tempfile (pattern = "toyrtplan", tmpdir = pat.dir,
                          fileext = ".dcm")
zz <- file (dcm.filename, "wb")
writeBin (toy.dicom.raw (), zz, size = 1)
close (zz)

# loading of rt-plan object
RTplan <- load.obj.from.dicom (dcm.filename)
str (RTplan)
# Cleaning  temporary directory
unlink (pat.dir, recursive = TRUE)
}
\seealso{
\link[espadon]{load.obj.data} and \link[espadon]{load.obj.from.Rdcm}
}
