% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display_histo.R
\name{display.histo}
\alias{display.histo}
\title{Display of the counts of a histogram}
\usage{
display.histo(
  histo,
  add = FALSE,
  xgrid = TRUE,
  ygrid = TRUE,
  MC.plot = FALSE,
  MC.col = grey.colors(4, rev = TRUE),
  ...
)
}
\arguments{
\item{histo}{"histo" class object.}

\item{add}{Boolean indicating whether to display the background image.}

\item{xgrid}{Boolean indicating the display of the x grid.}

\item{ygrid}{Boolean indicating the display of the y grid.}

\item{MC.plot}{Boolean. If \code{MC.plot = TRUE}, then \code{display.histo} displays,
if they exist, the quantile zones (Prob = {0, .05, .25, .5, .75, .95, 1})
of variations in counts.}

\item{MC.col}{Character string, a valid palette with 4 colours corresponding to
100\%, 95\%, 50\% and median of MC data.}

\item{...}{Additional arguments xlab, ylab, xlim, ylim, main, type, col, lwd, lty and log
managed by the \link[base]{plot} function.}
}
\value{
Returns a plot of the counts included in \code{histo}, with its median,
and the quantile areas (0\%-100\%), (2.5\%-97.5\%) and (25\%-75\%) of the \code{histo$counts}
variations, if they exist.
}
\description{
The \code{display.histo} function displays the counts of
"histo" class object.
}
\examples{
# loading of toy-patient objects (decrease dxyz for better result)
step <- 3
patient <- toy.load.patient (modality = "ct", dxyz = rep (step, 3))
CT <- patient$ct[[1]]

# histogram and display
H <- histo.vol (CT, breaks = seq (3, ceiling (CT$max.pixel), 1), 
                alias = "CT_hist")
display.histo (H, log = "y", lwd = 2)
}
\seealso{
\link[espadon]{display.dV_dx}.
}
