% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_clip.R
\name{spatial_clip}
\alias{spatial_clip}
\title{Clip values of spatial data.}
\usage{
spatial_clip(data, quantile, replace = NA, normalise = TRUE)
}
\arguments{
\item{data}{\code{raster} object, spatial data set to be processed.}

\item{quantile}{\code{Numeric} value, quantile value below which raster 
values are clipped.}

\item{replace}{\code{Numeric} value, replacement value, default is
\code{NA}.}

\item{normalise}{\code{Logical} value, optionally normalise values above 
threshold quantile between 0 and 1. Default is \code{TRUE}.}
}
\value{
\code{raster} object, data set with clipped values.
}
\description{
The function replaces raster values based on different thresholds.
}
\examples{

## load example data set
data(volcano)

## convert matrix to raster object
volcano <- raster::raster(volcano)

## clip values to those > quantile 0.5
volcano_clip <- spatial_clip(data = volcano, 
                                    quantile = 0.5)
                                    
## plot clipped data set
raster::plot(volcano_clip)
                     
}
\author{
Michael Dietze
}
\keyword{eseis}
