\name{constructESD}
\alias{constructESD}
\alias{pdfESD}
\alias{mapESDlocs}
\alias{queryLocations}
\alias{get5mintopo}
\alias{fortegn}
\alias{geo.inf}
\alias{gridESD}
\alias{mapESDquants}
\alias{mapESDprobs}
\alias{esdsummary}
\alias{gridded.c}
\alias{ESDinGoogle}
\alias{ESDdetails}
\alias{ESDreference}
\alias{reduce.rda.size}
\alias{rda2cdf}
\alias{figures}
\alias{KrigFields}
\alias{KrigSgeostat}
\title{Empirical-Statistical Downsacling For All.}
\description{
  R-package for processing results from empirical-statistical downscaling (ESD). 

  The code has been taylored to post-process data
  derived through the \code{clim.pact} (\url{http://cran.r-project.org/web/packages/clim.pact/index.html}) 
  and \code{met.no} packages (the latter is not posted on CRAN). The package uses the same
  ESD data as displayed in Google.Earth (\url{http://home.broadpark.no/~rbene/esd.google.earthTemp.kml}).

  The R-package assumes that the ESD involves a fairly large multi-model
  ensemble, typically involving 40-50 different simulations. Each
  simulation produces one time series for each location, typically over
  the period 1900-2100. The time series are the seasonal mean
  temperature (e.g. winter, spring, summer and autumn).

  More details about the nature of the data can be found in met.no Notes
  03/2009
  (\url{http://met.no/Forskning/Publikasjoner/?module=Files;action=File.getFile;ID=2319})
  and 15/2009 (\url{http://met.no/Forskning/Publikasjoner/?module=Files;action=File.getFile;ID=2631}).
  
\code{data(esdsummary)} retrieves ESD data generated by
\code{esdsummary()} in the \code{met.no}-package. These data consist of
coefficients of the best-fit polynomials to the 5-, and 95- percentiles as well as
the mean of the set of time series (1900-2100) of downscaled multi-model
ensemble (CMIP3). 

\code{constructESD} constructs time series of the 5-, and 95- percentiles as well as
the mean (1900-2100) of downscaled GCM (e.g from the CMIP3 data
set). These reconstructions are constructed from coefficients
describing the best-fit polynomials: \deqn{y(t)= c_0 + c_1
  t + c_2 t^2 + c_3 t^3 + c_4 t^4 + c_5 t^5,}{y(t)= c0 + c1 t + c2 t^2 + c3
  t^3 + c4 t^4 + c5 t^5,} where t is the time. 

\code{pdfESD} produces a pdf (Gaussian) of the seasonal temperature
downscaled from the multi-model ensemble at a given location. Note,
this pdf is not necessarily the same as the true pdf for the real temperature.

\code{mapESDlocs} produces a map showing the locations for which there
are multi-model ESD results in the \code{esd4all} package.

\code{queryLocations} returns the name of the locations of the ESD locations.

\code{get5mintopo} retrieves a 5-minute resolution data file of the
topography over Internet and saves the data locally in a suitable format
for the use in the \code{esd4all} package.

\code{fortegn} a utility used internally - returns -1 or +1.

\code{geo.inf} is a function that uses a geographical regression model
(GRM) to grid the results, and then adds the residuals through
interpolation (kriging or 2D splines). This is an internal function.

\code{gridESD} is the main function that grids the coefficients used to
describe the best-fit polynomials providing smooth approximations of the
time series for 5- and 95-percentiles and the ensemble mean. The function uses \code{geo.inf}.

\code{gridded.c} is produced by \code{gridESD}. In the CRAN-version (1.0-3), a
reduced version of this gridded data set is used due to size
limitations, but a fuller version is available from \url{http://noserc.met.no/grtools/esd4all.html}.

\code{mapESDquants}  constructs map of derived quantiles. 

\code{mapESDprobs} construct map of the fraction of GCMs with value
below/higher then threshold.

\code{esdsummary} contains coefficients describing the polynomials of
the 5th and 95th percentiles as well as ensemble mean of ESD analysis
for a large number of locations around the world, seen in \url{http://eklima.met.no/metno/esd/esd.google.earthTemp.kmz}

\code{gridded.c} contains results from gridding the coefficients (stored
in \code{esdsummary}) over northern Europe.

\code{ESDinGoogle} views the ESD results in GoogleEarth

\code{ESDdetails} provides details about the ESD results and explains how the figures should be interpreted. 
\code{ESDreference} provides a link to a proper reference for the ESD - Benestad, R.E. (2005) Climate change scenarios for northern Europe from multi-model IPCC AR4 climate simulations GRL, 32  doi:10.1029/2005GL023401 No. 17, L17704.

\code{rsd2cdf} reads the gridded data in an \code{rda}-file and saves
these as a netCDF file. 

\code{figures} Makes figures showing maps of the 95-percentile for
summer (JJA) mean temperature and probability of below freezing mean
winter (DJF) temperatures.

}
\usage{
constructESD(location,plot=TRUE,get.data="data(esdsummary,envir=environment())",
             mfrow=c(2,2))
pdfESD(location,plot=TRUE,get.data="data(esdsummary,envir=environment())",
       year=2050,ref=NULL,mfrow=c(2,2),what="pdf")
mapESDlocs(get.data="data(esdsummary,envir=environment())")
queryLocations(nr=NULL,get.data="data(esdsummary,envir=environment())")
get5mintopo(browser = "firefox", url ="http://marine.rutgers.edu/po/tools/gridpak/etopo5.nc")
fortegn(a,b)
geo.inf(g.obj,do.km=TRUE,x.scale=1000,
                    predict=TRUE,krig=TRUE,krig.Nx=NULL,krig.Ny=NULL,
                    x.rng=c(-10,32),y.rng=c(44,70),plot=FALSE,
                    krig.package="fields",
                    use.previous.estimates=TRUE,linear.intp=TRUE)
KrigFields(resid,lon.grd,lat.grd)
KrigSgeostat(resid,lon.grd,lat.grd,do.km)
gridESD(get.data = "data(esdsummary,envir=environment())",
                 plot = FALSE, x.rng = c(-30, 50), y.rng = c(40, 72),
                 x.scale = 1000, do.km = TRUE, krig = TRUE, new = TRUE,
                 krig.Nx = 30, krig.Ny = 30, use.previous.estimates =
                 TRUE, linear.intp = TRUE, krig.package = "fields",
                 fname = "gridded.c.rda")
mapESDquants(what="q95",season=3,year=2050,ref=NULL,
                         get.data1="data(gridded.c,envir=environment())",
                         get.data2="data(esdsummary,envir=environment())",
                         plot=TRUE)
mapESDprobs(thresh=0,season=1,year=2050,ref=NULL,
             get.data="data(gridded.c,envir=environment())",plot=TRUE)
data(esdsummary)
data(gridded.c)
ESDinGoogle(browser = "firefox", url="http://eklima.met.no/metno/esd/esd.google.earthTemp.kmz") 
ESDdetails(browser = "firefox", url="http://met.no/Forskning/Publikasjoner/") 
rda2cdf(get.data="data(gridded.c,envir=environment())")
figures(get.data="data(gridded.c,envir=environment())")
reduce.rda.size(get.data="data(gridded.c,envir=environment())",reduce.res=TRUE,
                            nx=100,ny=100)
}
\arguments{
  \item{location}{Name of site}
  \item{plot}{flag: TRUE or FALSE}
  \item{get.data}{Method for getting the data}
  \item{year}{Scenario year}
  \item{nr}{Station number}
  \item{browser}{Preferred browser}
  \item{url}{URLs of on-line reports or KML-files.}
  \item{g.obj}{List object holding ESD data for a number of sites. Used
    for gridding.}
  \item{do.km}{FLAG: TRUE use km rather than lon-lat coordinates.}
  \item{x.scale}{Spatila scale: 1000 implies units of km.}
  \item{predict}{FLAG: TRUE or FALSE}
  \item{krig}{FLAG: FALSE implies a bi-linear interpolation rather than
    kriging. Two kriging options are avialble, specified by the argument
  \code{krig.package}. Past tests have revealed some problems with the
  kriging options, however.}
  \item{krig.package}{Specify package for kriging analysis: "fields" or "sgeostat"}
  \item{x.rng}{x range for selection of sites in gridding}
  \item{y.rng}{y range for selection of sites in gridding}
  \item{use.previous.estimates}{FLAG: TRUE for avoiding repeating
    lengthy calculations}
  \item{linear.intp}{used for the linear argument in \code{interp}}
  \item{ref}{Reference year}
  \item{fname}{File name for \code{gridded.c}.}
  \item{what}{Specification of type}
  \item{a}{}
  \item{b}{}
  \item{reduce.res}{TRUE: use \code{interp} to reduce the spatial
    resolution, otherwise save only the land points.}
  \item{nx}{}
  \item{ny}{}
  \item{mfrow}{}
  \item{krig.Nx}{To specify coarser grid for residual gridding}
  \item{krig.Ny}{To specify coarser grid for residual gridding}
  \item{new}{FALSE: try to continue on a previous job}
  \item{season}{Season}
  \item{get.data1}{Method for getting the data}
  \item{get.data2}{Method for getting the data}
  \item{thresh}{Threshold value for estimating probabilities}
  \item{resid}{List object holding the residuals from GRM}
  \item{lon.grd}{longitude coordinates of grid}
  \item{lat.grd}{Latitude coordinates of grid}
}
\value{
}
\author{R.E. Benestad}
\examples{
\dontrun{
ESDinGoogle()
data(esdsummary)
mapESDlocs()
queryLocations() -> a
constructESD(a[1]) -> b
pdfESD(a[1])
mapESDquants() -> map.q95
mapESDprobs() -> map.pr.T.lt.0
}
}
\keyword{}
