% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_mdiff_one.R
\name{estimate_mdiff_one}
\alias{estimate_mdiff_one}
\title{Estimates for a single-group design with a continuous outcome
variable compared to a reference or population value}
\usage{
estimate_mdiff_one(
  data = NULL,
  outcome_variable = NULL,
  comparison_mean = NULL,
  comparison_sd = NULL,
  comparison_n = NULL,
  reference_mean = 0,
  outcome_variable_name = "My outcome variable",
  conf_level = 0.95,
  save_raw_data = TRUE
)
}
\arguments{
\item{data}{For raw data - a data frame or tibble}

\item{outcome_variable}{For raw data - The column name of the outcome
variable, or a vector of numeric data}

\item{comparison_mean}{For summary data, a numeric}

\item{comparison_sd}{For summary data, numeric > 0}

\item{comparison_n}{For summary data, a numeric integer > 0}

\item{reference_mean}{Reference value, defaults to 0}

\item{outcome_variable_name}{Optional friendly name for the outcome variable.
Defaults to 'My outcome variable' or the outcome variable column name if a
data frame is passed.}

\item{conf_level}{The confidence level for the confidence interval.  Given in
decimal form.  Defaults to 0.95.}

\item{save_raw_data}{For raw data; defaults to TRUE; set to FALSE to save
memory by not returning raw data in estimate object}
}
\value{
Returns object of class esci_estimate
\itemize{
\item \strong{overview}
\itemize{
\item \emph{outcome_variable_name} -
\item \emph{mean} -
\item \emph{mean_LL} -
\item \emph{mean_UL} -
\item \emph{median} -
\item \emph{median_LL} -
\item \emph{median_UL} -
\item \emph{sd} -
\item \emph{min} -
\item \emph{max} -
\item \emph{q1} -
\item \emph{q3} -
\item \emph{n} -
\item \emph{missing} -
\item \emph{df} -
\item \emph{mean_SE} -
\item \emph{median_SE} -
}
\item \strong{es_mean}
\itemize{
\item \emph{outcome_variable_name} -
\item \emph{effect} -
\item \emph{effect_size} -
\item \emph{LL} -
\item \emph{UL} -
\item \emph{SE} -
\item \emph{df} -
\item \emph{ta_LL} -
\item \emph{ta_UL} -
}
\item \strong{es_median}
\itemize{
\item \emph{outcome_variable_name} -
\item \emph{effect} -
\item \emph{effect_size} -
\item \emph{LL} -
\item \emph{UL} -
\item \emph{SE} -
\item \emph{df} -
\item \emph{ta_LL} -
\item \emph{ta_UL} -
}
\item \strong{raw_data}
\itemize{
\item \emph{grouping_variable} -
\item \emph{outcome_variable} -
}
\item \strong{es_mean_difference}
\itemize{
\item \emph{outcome_variable_name} -
\item \emph{effect} -
\item \emph{effect_size} -
\item \emph{LL} -
\item \emph{UL} -
\item \emph{SE} -
\item \emph{df} -
\item \emph{ta_LL} -
\item \emph{ta_UL} -
\item \emph{type} -
}
\item \strong{es_median_difference}
\itemize{
\item \emph{outcome_variable_name} -
\item \emph{effect} -
\item \emph{effect_size} -
\item \emph{LL} -
\item \emph{UL} -
\item \emph{SE} -
\item \emph{df} -
\item \emph{ta_LL} -
\item \emph{ta_UL} -
\item \emph{type} -
}
\item \strong{es_smd}
\itemize{
\item \emph{outcome_variable_name} -
\item \emph{effect} -
\item \emph{effect_size} -
\item \emph{LL} -
\item \emph{UL} -
\item \emph{numerator} -
\item \emph{denominator} -
\item \emph{SE} -
\item \emph{df} -
\item \emph{d_biased} -
}
}
}
\description{
Returns object
\code{estimate_mdiff_one} is suitable for a single-group design
with a continuous outcome variable that is compared to a reference
or population value.  It can express estimates as mean differences,
standardized mean differences (Cohen's d) or median differences
(raw data only).  You can pass raw data or summary data.
}
\details{
Reach for this function in place of a \emph{z}-test or one-sample \emph{t}-test.

Once you generate an estimate with this function, you can visualize
it with \code{\link[=plot_mdiff]{plot_mdiff()}} and you can test hypotheses with
\code{\link[=test_mdiff]{test_mdiff()}}.

The estimated mean differences are from \code{\link[statpsych:ci.mean1]{statpsych::ci.mean1()}}.

The estimated SMDs are from \code{\link[=CI_smd_one]{CI_smd_one()}}.

The estimated median differences are from \code{\link[statpsych:ci.median1]{statpsych::ci.median1()}}
}
\examples{
# From raw data
data("data_penlaptop1")
estimate_from_raw <- esci::estimate_mdiff_one(
  data = data_penlaptop1[data_penlaptop1$condition == "Pen", ],
  outcome_variable = transcription,
  reference_mean = 10
)

# To visualize the mean difference estimate
myplot_from_raw <- esci::plot_mdiff(estimate_from_raw, effect_size = "mean")

# To conduct a hypothesis test
res_htest_from_raw <- esci::test_mdiff(
  estimate_from_raw,
  effect_size = "mean",
  rope = c(-2, 2)
)


# From summary data
mymean <- 12.09
mysd <- 5.52
myn <- 103

estimate_from_summary <- esci::estimate_mdiff_one(
  comparison_mean = mymean,
  comparison_sd = mysd,
  comparison_n = myn,
  reference_mean = 12
)

# To visualize the estimate
myplot_from_sumary <- esci::plot_mdiff(
  estimate_from_summary,
  effect_size = "mean"
)

# To conduct a hypothesis test
res_htest_from_summary <- esci::test_mdiff(
  estimate_from_summary,
  effect_size = "mean",
  rope = c(-2, 2)
)

}
