% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stop_when_too_toxic.R
\name{stop_when_too_toxic}
\alias{stop_when_too_toxic}
\title{Stop when a dose is too toxic.}
\usage{
stop_when_too_toxic(parent_selector_factory, dose, tox_threshold, confidence)
}
\arguments{
\item{parent_selector_factory}{Object of type \code{\link{selector_factory}}.}

\item{dose}{\code{'any'} to stop when any dose is too toxic;
\code{'recommended'} to stop when the recommended dose is too toxic; or an
integer to stop when a particular dose-level is too toxic.}

\item{tox_threshold}{We are interested in toxicity probabilities greater than
this threshold.}

\item{confidence}{Stop when there is this much total probability mass
supporting that the toxicity rate exceeds the threshold.}
}
\value{
an object of type \code{\link{selector_factory}} that can fit a
dose-finding model to outcomes.
}
\description{
This method stops a dose-finding trial when sufficient probabilistic
confidence is reached that the rate of toxicity at a dose exceeds some
threshold. In other words, it stops when it is likely that a dose is too
toxic. It can stop when the rule is triggered at the recommended dose, at a
particular dose, or at any dose. See Details.
}
\details{
The method for calculating probability mass for toxicity rates will
ultimately be determined by the dose-finding model used and the attendant
inferential mechanism. For instance, the \code{\link[dfcrm]{crm}} function in
the dfcrm package calculates the posterior expected mean and variance of the
slope parameter in a CRM model. It does not use MCMC to draw samples from the
posterior distribution. Thus, to perform inference on the posterior
probability of toxicity, this package assumes the dfcrm slope parameter
follows a normal distribution with the mean and variance calculated by dfcrm.
In contrast, the \code{stan_crm} function in the \code{trialr}
package needs no such assumption because it samples from the posterior
parameter distribution and uses those samples to infer on the posterior
probability of toxicity at each dose, dependent on the chosen model for the
dose-toxicity curve.
}
\examples{
skeleton <- c(0.05, 0.1, 0.25, 0.4, 0.6)
target <- 0.25

# We compare a CRM model without a toxicity stopping rule to one with it:
model1 <- get_dfcrm(skeleton = skeleton, target = target)
model2 <- get_dfcrm(skeleton = skeleton, target = target) \%>\%
  stop_when_too_toxic(dose = 'any', tox_threshold = 0.5, confidence = 0.7)

outcomes <- '1NNN 2NNN 3NNT 3NNN 3TNT 2NNN'
fit1 <- model1 \%>\% fit(outcomes)
fit2 <- model2 \%>\% fit(outcomes)

# Naturally the first does not advocate stopping:
fit1 \%>\% recommended_dose()
fit1 \%>\% continue()

# However, after the material toxicity at dose 3, ithe rule is fired:
fit2 \%>\% recommended_dose()
fit2 \%>\% continue()
# To verify the requirement to stop, let's calculate the probability that the
# toxicity rate exceeds 50\%
fit2 \%>\% prob_tox_exceeds(0.5)
}
