% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Deprecated.R, R/convert_d2r.R
\name{esc_d2r}
\alias{esc_d2r}
\alias{convert_d2r}
\title{Convert effect size d into correlation}
\usage{
esc_d2r(d, se, v, grp1n, grp2n, info = NULL, study = NULL)

convert_d2r(d, se, v, grp1n, grp2n, info = NULL, study = NULL)
}
\arguments{
\item{d}{The effect size \code{d}.}

\item{se}{The standard error of \code{d}. One of \code{se} or \code{v}
must be specified.}

\item{v}{The variance of \code{d}. One of \code{se} or \code{v} must be
specified.}

\item{grp1n}{Treatment group sample size.}

\item{grp2n}{Control group sample size.}

\item{info}{String with information on the transformation. Used for the
print-method. Usually, this argument can be ignored}

\item{study}{Optional string with the study name. Using \code{\link{combine_esc}} or
\code{as.data.frame} on \code{esc}-objects will add this as column
in the returned data frame.}
}
\value{
The effect size \code{es}, the standard error \code{se}, the variance
        of the effect size \code{var}, the lower and upper confidence limits
        \code{ci.lo} and \code{ci.hi}, the weight factor \code{w} and the
        total sample size \code{totaln}. Furthermore, Fisher's z and
        confidence intervals are returned.
}
\description{
Compute effect size correlation from effect size \code{d}.
}
\examples{
convert_d2r(d = 0.7, se = 0.5, grp1n = 70, grp2n = 80)

}
\references{
Lipsey MW, Wilson DB. 2001. Practical meta-analysis. Thousand Oaks, Calif: Sage Publications
            \cr \cr
            Wilson DB. 2016. Formulas Used by the "Practical Meta-Analysis Effect Size Calculator". Unpublished manuscript: George Mason University
}
