% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errors.R
\docType{package}
\name{errors}
\alias{errors}
\alias{errors-package}
\alias{errors}
\alias{errors}
\alias{errors_max}
\alias{errors}
\alias{errors_min}
\alias{errors}
\alias{errors<-}
\alias{errors}
\alias{set_errors}
\alias{errors}
\alias{as.errors}
\title{\pkg{errors}: Error Propagation for R Vectors}
\usage{
errors(x)

errors_max(x)

errors_min(x)

errors(x) <- value

set_errors(x, value = 0)

as.errors(x, value = 0)
}
\arguments{
\item{x}{a numeric object, or object of class \code{errors}.}

\item{value}{a numeric vector of length 1 or the same length as \code{x}.}
}
\value{
\code{errors} returns a vector of errors. \code{errors_max}
(\code{errors_min}) returns the object plus (minus) the errors.

\code{`errors<-`} sets the error values and converts \code{x} into an object
of class \code{errors}. \code{set_errors} is a pipe-friendly version of
\code{`errors<-`} and returns an object of class \code{errors}. \code{as.errors}
is an alias for \code{set_errors} with \code{value = 0} by default.
}
\description{
Support for painless automatic error propagation in numerical operations.
}
\details{
Errors are automagically propagated when you operate with \code{errors}
objects, or with \code{errors} and numeric objects. By default, propagation
is made using a first-order Taylor series expansion.
}
\examples{
x = 1:3
class(x)
errors(x) <- 0.1
class(x)
x
errors(x) <- seq(0.1, 0.3, 0.1)
x
# numeric values are automatically coerced to errors
x^2 + x
}
\author{
Iñaki Ucar
}
