% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm.san.R
\name{san}
\alias{san}
\alias{san.default}
\alias{san.formula}
\alias{san.ergm_model}
\title{Use Simulated Annealing to attempt to match a network to a vector of mean
statistics}
\usage{
san(object, ...)

\method{san}{formula}(
  object,
  response = NULL,
  reference = ~Bernoulli,
  constraints = ~.,
  target.stats = NULL,
  nsim = NULL,
  basis = NULL,
  output = c("network", "edgelist", "ergm_state"),
  only.last = TRUE,
  control = control.san(),
  verbose = FALSE,
  offset.coef = NULL,
  ...
)

\method{san}{ergm_model}(
  object,
  reference = ~Bernoulli,
  constraints = ~.,
  target.stats = NULL,
  nsim = NULL,
  basis = NULL,
  output = c("network", "edgelist", "ergm_state"),
  only.last = TRUE,
  control = control.san(),
  verbose = FALSE,
  offset.coef = NULL,
  ...
)
}
\arguments{
\item{object}{Either a \code{\link{formula}} or an \code{\link{ergm}} object. The
\code{\link{formula}} should be of the form \code{y ~ <model terms>}, where
\code{y} is a network object or a matrix that can be coerced to a
\code{\link{network}} object.  For the details on the possible \code{<model
  terms>}, see \code{\link{ergmTerm}}.  To create a
\code{\link[network]{network}} object in , use the
\code{network()} function, then add nodal attributes to it using
the \code{\%v\%} operator if necessary.}

\item{\dots}{Further arguments passed to other functions.}

\item{response}{Either a character string, a formula, or \code{NULL} (the default), to specify the response attributes and whether the ERGM is binary or valued. Interpreted as follows: \describe{

\item{\code{NULL}}{Model simple presence or absence, via a binary ERGM.}

\item{character string}{The name of the edge attribute whose value is to be modeled. Type of ERGM will be determined by whether the attribute is \code{\link{logical}} (\code{TRUE}/\code{FALSE}) for binary or \code{\link{numeric}} for valued.}

\item{a formula}{must be of the form \code{NAME~EXPR|TYPE} (with \code{|} being literal). \code{EXPR} is evaluated in the formula's environment with the network's edge attributes accessible as variables. The optional \code{NAME} specifies the name of the edge attribute into which the results should be stored, with the default being a concise version of \code{EXPR}. Normally, the type of ERGM is determined by whether the result of evaluating \code{EXPR} is logical or numeric, but the optional \code{TYPE} can be used to override by specifying a scalar of the type involved (e.g., \code{TRUE} for binary and \code{1} for valued).}

}}

\item{reference}{A one-sided formula specifying
the reference measure (\eqn{h(y)}) to be used.
See help for \link[=ergm-references]{ERGM reference measures} implemented in the
\strong{\link[=ergm-package]{ergm}} package.}

\item{constraints}{A one-sided formula specifying one or more constraints on
the support of the distribution of the networks being simulated. See the
documentation for a similar argument for \code{\link{ergm}} and see
\link[=ergmConstraint]{list of implemented constraints} for more information. For
\code{simulate.formula}, defaults to no constraints. For
\code{simulate.ergm}, defaults to using the same constraints as those with
which \code{object} was fitted.}

\item{target.stats}{A vector of the same length as the number of non-offset statistics
implied by the formula, which is either \code{object} itself in the case of
\code{san.formula} or \code{object$formula} in the case of \code{san.ergm}.}

\item{nsim}{Number of networks to generate. Deprecated: just use \code{\link[=replicate]{replicate()}}.}

\item{basis}{If not NULL, a \code{network} object used to start the Markov
chain.  If NULL, this is taken to be the network named in the formula.}

\item{output}{Character, one of \code{"network"} (default),
\code{"edgelist"}, or \code{"ergm_state"}: determines the
output format. Partial matching is performed.}

\item{only.last}{if \code{TRUE}, only return the last network generated;
otherwise, return a \code{\link{network.list}} with \code{nsim} networks.}

\item{control}{A list of control parameters for algorithm tuning,
typically constructed with \code{\link[=control.san]{control.san()}}. Its documentation
gives the the list of recognized control parameters and their
meaning. The more generic utility \code{\link[=snctrl]{snctrl()}} (StatNet ConTRoL)
also provides argument completion for the available control
functions and limited argument name checking.}

\item{verbose}{A logical or an integer to control the amount of
progress and diagnostic information to be printed. \code{FALSE}/\code{0}
produces minimal output, with higher values producing more
detail. Note that very high values (5+) may significantly slow
down processing.}

\item{offset.coef}{A vector of offset coefficients; these must be passed in by the user.
Note that these should be the same set of coefficients one would pass to \code{ergm} via
its \code{offset.coef} argument.}

\item{formula}{(By default, the \code{formula} is taken from the \code{ergm}
object.  If a different \code{formula} object is wanted, specify it here.}
}
\value{
A network or list of networks that hopefully have network
statistics close to the \code{target.stats} vector. Additionally,
\code{\link[=attr]{attr()}}-style attributes \code{formula} and \code{stats} are included.
}
\description{
This function attempts to find a network or networks whose statistics match
those passed in via the \code{target.stats} vector.
}
\details{
Acceptance probabilities for proposed toggles are computed as
we now describe.  There are two contributions: one from targeted
statistics and one from offsets.

For the targeted statistics, a matrix of weights \code{W} is determined on
each \code{san} iteration as follows.  On the first iteration, the matrix
\code{W} is the \code{n} by \code{n} identity matrix (\code{n} = number of
target statistics), divided by \code{n}.  On subsequent iterations: if
\code{control$SAN.invcov.diag = FALSE} (the default), then the matrix
\code{W} is the inverse of the covariance matrix of the targeted
statistics, divided by the sum of its (the inverse's) diagonal;
if \code{control$SAN.invcov.diag = TRUE}, then \code{W} is the inverse
of the diagonal (regarded as a matrix) of the covariance matrix of the
targeted statistics, divided by the sum of its (the inverse's) diagonal.
In either of these two cases, the covariance matrix is computed based on
proposals (not acceptances) made on the previous iteration, and the
normalization for \code{W} is such that \code{sum(diag(W)) = 1}.  The
component of the acceptance probability coming from the targeted statistics
is then computed for a given \code{W} as \code{exp([y.Wy - x.Wx]/T)} where
\code{T} is the temperature, \code{y} the column vector of differences
\code{network statistics - target statistics} computed before the current
proposal is made, \code{x} the column vector of differences
\code{network statistics - target statistics} computed assuming the current proposal
is accepted, and \code{.} the dot product.  If \code{control$SAN.maxit > 1},
then on the \code{i}th iteration, the temperature \code{T} takes the value
\code{control$SAN.tau * (1/i - 1/control$SAN.maxit)/(1 - 1/control$SAN.maxit)};
if \code{control$SAN.maxit = 1}, then the temperature \code{T} takes the
value \code{0}.  Thus, \code{T} steps down from \code{control$SAN.tau} to
\code{0} and is always \code{0} on the final iteration.

Offsets also contribute to the acceptance probability, as follows.  If
\code{eta} are the canonical offsets and \code{Delta} the corresponding
change statistics for a given proposal, then the offset contribution to
the acceptance probability is simply \code{exp(eta.Delta)} where
\code{.} denotes the dot product.  By default, finite offsets are ignored,
but this behavior can be changed by setting
\code{control$SAN.ignore.finite.offsets = FALSE}.

The overall acceptance probability is the product of the targeted statistics
contribution and the offset contribution (with the product capped at one).
}
\section{Methods (by class)}{
\itemize{
\item \code{san(formula)}: Sufficient statistics are specified by a \code{\link{formula}}.

\item \code{san(ergm_model)}: A lower-level function that expects a pre-initialized \code{\link{ergm_model}}.

}}
\examples{
\donttest{
# initialize x to a random undirected network with 50 nodes and a density of 0.1
x <- network(50, density = 0.05, directed = FALSE)
 
# try to find a network on 50 nodes with 300 edges, 150 triangles,
# and 1250 4-cycles, starting from the network x
y <- san(x ~ edges + triangles + cycle(4), target.stats = c(300, 150, 1250))

# check results
summary(y ~ edges + triangles + cycle(4))

# initialize x to a random directed network with 50 nodes
x <- network(50)

# add vertex attributes
x \%v\% 'give' <- runif(50, 0, 1)
x \%v\% 'take' <- runif(50, 0, 1)

# try to find a set of 100 directed edges making the outward sum of
# 'give' and the inward sum of 'take' both equal to 62.5, so in
# edges (i,j) the node i tends to have above average 'give' and j
# tends to have above average 'take'
y <- san(x ~ edges + nodeocov('give') + nodeicov('take'), target.stats = c(100, 62.5, 62.5))

# check results
summary(y ~ edges + nodeocov('give') + nodeicov('take'))


# initialize x to a random undirected network with 50 nodes
x <- network(50, directed = FALSE)

# add a vertex attribute
x \%v\% 'popularity' <- runif(50, 0, 1)

# try to find a set of 100 edges making the total sum of
# popularity(i) and popularity(j) over all edges (i,j) equal to
# 125, so nodes with higher popularity are more likely to be
# connected to other nodes
y <- san(x ~ edges + nodecov('popularity'), target.stats = c(100, 125))
 
# check results
summary(y ~ edges + nodecov('popularity'))

# creates a network with denser "core" spreading out to sparser
# "periphery"
plot(y)
}
}
\keyword{models}
