% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R
\name{dyadcov-ergmTerm}
\alias{dyadcov-ergmTerm}
\alias{InitErgmTerm.dyadcov}
\title{Dyadic covariate}
\usage{
# binary: dyadcov(x, attrname=NULL)
}
\arguments{
\item{x, attrname}{either a square matrix of covariates, one for each possible
edge in the network, the name of a network attribute of covariates,
or a network; if the latter, optional argument \code{attrname} provides
the name of the quantitative edge attribute to use for covariate values
(in this case, missing edges in \code{x} are assigned a covariate value
of zero).}
}
\description{
This term adds three statistics to the model, each equal to the sum of the
covariate values for all dyads occupying one of the three possible non-empty
dyad states (mutual, upper-triangular asymmetric, and lower-triangular
asymmetric dyads, respectively), with the empty or null state serving as a
reference category. If the network is undirected, \code{x} is either a
matrix of edgewise covariates, or a network; if the latter, optional
argument \code{attrname} provides the name of the edge attribute to use for
edge values. This term adds one statistic to the model, equal to the sum of
the covariate values for each edge appearing in the network. The
\code{edgecov} and \code{dyadcov} terms are equivalent for undirected
networks.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.
}
\concept{categorical nodal attribute}
\concept{directed}
\concept{dyad-independent}
\concept{undirected}
