% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crtDataSimulation.R
\name{crtDataSimulation}
\alias{crtDataSimulation}
\title{Simulate Clustered Randomized Trial (CRT) Data}
\usage{
crtDataSimulation(
  ni,
  ns,
  np,
  nstreated,
  sigma,
  ICC,
  sigmaPret,
  B0,
  B1,
  es,
  seed,
  attritionrates
)
}
\arguments{
\item{ni}{The number of intervention groups excluding the control group.}

\item{ns}{The total number of schools.}

\item{np}{The number of pupils per school.}

\item{nstreated}{The number of schools in each group, including the control group. It should be specified as an integer vector of length ni + 1.}

\item{sigma}{The standard deviation of the individual-level error.}

\item{ICC}{The intra-class correlation coefficient.}

\item{sigmaPret}{The standard deviation of the pretest scores.}

\item{B0}{The intercept of the model.}

\item{B1}{The coefficient for the pretest covariate in the model.}

\item{es}{The standardized effect sizes for each intervention group. It should be specified as a numeric vector.}

\item{seed}{The random seed for reproducibility.}

\item{attritionrates}{The proportion of attrition for each group, including the control group. It should be specified as a numeric vector of length ni + 1.}
}
\value{
A \code{data.frame} containing:
\describe{
\item{pupils}{Unique pupil ID}
\item{schools}{School ID}
\item{interventions}{Intervention group (0 = control, 1 to \code{ni} for interventions)}
\item{pretest}{Simulated pretest scores}
\item{posttest}{Simulated posttest scores (NA if attrited)}
}
}
\description{
This function simulates a multiple intervention arms CRT data. The model
includes intervention and pre-test scores as covariates.
}
\examples{
crtdata <- crtDataSimulation(ni = 3, ns = 10, np = 100, nstreated = c(2, 3, 2, 3), 
sigma = 1, ICC = 0.3, sigmaPret = 1, B0 = 1.45, B1 = 1.7, es = c(0.1, 0.2, 0.5), 
seed = 1234, attritionrates = c(0, 0.1, 0.2, 0.1))
head(crtdata)

}
