% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{utils}
\alias{utils}
\alias{val_ag_name}
\alias{preproc}
\alias{pull_seq}
\alias{comb_pred_tbl}
\alias{comb_pred_tbl_mhcI}
\alias{find_nonself}
\alias{pull_ag_self}
\alias{find_core_mut}
\alias{align_seq}
\alias{pull_obj_name}
\title{Basic functions of the package}
\usage{
val_ag_name(ag_present)

preproc(allele_in, link)

pull_seq(alleles_in, tbl_ref_in)

comb_pred_tbl(nm_method, nm_sht, nm_fd, thold_score, thold_rank)

comb_pred_tbl_mhcI(nm_method, nm_fd, thold_score, thold_rank)

find_nonself(dat_in)

pull_ag_self(vec_in)

find_core_mut(dat_in)

align_seq(seq1, seq2, gapopening = 0, gapextension = 8)

pull_obj_name(x)
}
\arguments{
\item{ag_present}{a vector of locus name(s) to make binding predictions for

preproc() format and validate allele names}

\item{allele_in}{a vector contains allele name(s)}

\item{link}{a string of url of MHC I or II api

pull_seq() pull out sequence of each allele based on ref table}

\item{alleles_in}{vector, allele names}

\item{tbl_ref_in}{dataframe, reference table, default is human_all.csv from github

comb_pred_tbl() combine individual prediction tables by method, exclude none-binders and keep strong and weak binders only}

\item{nm_method}{string, prediction method used for IEDB prediction}

\item{nm_sht}{string, short name of alleles}

\item{nm_fd}{string, folder name which contains predict tables from IEDB}

\item{thold_score}{list of vectors, binder thresholds by ic50 score}

\item{thold_rank}{vector, binder thresholds by percentile rank

find_nonself() find nonself binding peptides}

\item{dat_in}{dataframe with pep_stim, core, pep_self selected from pull_ag_self

align_seq() align protein sequences}

\item{vec_in}{dataframe with pep_stim, core, aligned ag_stim and ag_self columns

find_core_mut() find mutation position to core}

\item{seq1}{string, unaligned sequence of ag_stim}

\item{seq2}{string, unaligned sequence of ag_self}

\item{gapopening}{numeric, the cost for opening a gap in the alignment.}

\item{gapextension}{numeric, the incremental cost incurred along the length of the gap in the alignment

pull_obj_name()}

\item{x, }{name of an object}
}
\description{
val_ag_name() validation of name of binding locus
}
