% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_reference_levels.R
\name{add_reference_levels}
\alias{add_reference_levels}
\title{Add reference levels}
\usage{
add_reference_levels(model_object)
}
\arguments{
\item{model_object}{A cox.ph object}
}
\description{
\code{add_reference_levels} Adds reference levels to regression
    model object
}
\details{
Prints summary statistics of cox.ph model using the
    \code{broom}-package, and adds a reference level to the
    categorical predictors, as is commonly used in epidemiological
    publications.
}
\examples{
# Model for which I want reference levels printed in the output.
lung <- survival::lung
lung$species <- iris$Species[ sample.int( 150, 228, replace = TRUE )]
input_to_function <- survival::coxph( survival::Surv( time, status == 2 ) ~ age +
sex  + ph.karno + wt.loss + species, data =  lung)
add_reference_levels( model_object = input_to_function)
}
