% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_param.R
\name{extraction_functions}
\alias{extraction_functions}
\alias{.fit_range}
\alias{.fit_percentiles}
\title{Function for extracting distribution parameters}
\usage{
.fit_range(param, val, dist = c("lnorm", "gamma", "weibull", "norm"))

.fit_percentiles(param, val, dist = c("lnorm", "gamma", "weibull", "norm"))
}
\arguments{
\item{param}{Named \code{numeric} vector of the distribution parameters to be
optimised.}

\item{val}{\code{Numeric} vector, in the case of using percentiles it contains
the values at the percentiles and the percentiles, in the case of median and
range it contains the median, lower range, upper range and the number of
sample points to evaluate the function at.}

\item{dist}{A \code{character} string with the name of the distribution for
fitting. Naming follows the base R distribution names (e.g. \code{lnorm} for
lognormal).}
}
\description{
Set of functions that can be used to estimate the parameters of a
distribution (lognormal, gamma, Weibull, normal) via optimisation from
either the percentiles or the median and ranges.
}
\author{
Adam Kucharski, Joshua W. Lambert
}
\keyword{internal}
