% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/owas_mixed_effects.R
\name{owas_mixed_effects}
\alias{owas_mixed_effects}
\title{Perform 'omics wide association study with linear or generalized mixed
models}
\usage{
owas_mixed_effects(
  df,
  var,
  omics,
  random_effects,
  covars = NULL,
  var_exposure_or_outcome,
  family = "gaussian",
  confidence_level = 0.95,
  conf_int = FALSE,
  REML = TRUE,
  ref_group = NULL
)
}
\arguments{
\item{df}{Dataset}

\item{var}{Name of the variable or variables of interest- this is usually
either an exposure variable or an outcome variable. Can be either
continuous or dichotomous. For dichotomous variables, must set \code{family}
to "binomial", and values must be either 0/1 or a factor with the first
level representing the reference group. Can handle multiple variables, but
they must all be of the same \code{family}.}

\item{omics}{Names of all omics features in the dataset}

\item{random_effects}{Random effects, formatted as specified by
\link[lme4]{lmer} or \link[lme4]{glmer}}

\item{covars}{Names of covariates (can be NULL)}

\item{var_exposure_or_outcome}{Is the variable of interest an exposure
(independent variable) or outcome (dependent variable)? Must be either
"exposure" or "outcome"}

\item{family}{"gaussian" (default) for linear models (via
\link[lmerTest]{lmer}) or "binomial" for logistic (via \link[lme4]{glmer})}

\item{confidence_level}{Confidence level for marginal significance
(defaults to 0.95, or an alpha of 0.05)}

\item{conf_int}{Should Confidence intervals be generated for the estimates?
Default is FALSE. Setting to TRUE will take longer. For logistic models,
calculates Wald confidence intervals via \code{confint.default}.}

\item{REML}{logical scalar - Should the estimates be chosen to optimize
the REML criterion (as opposed to the log-likelihood)? Default is TRUE}

\item{ref_group}{Reference category if the variable of interest is a
character or factor. If not, can leave empty.}
}
\value{
A data frame with 6 columns:
feature_name: name of the omics feature
estimate: the model estimate for the feature. For linear models, this is the
beta; for logistic models, this is the log odds.
se: Standard error of the estimate
test statistic: t-value
p_value: p-value for the estimate
adjusted_pval: FDR adjusted p-value
threshold: Marginal significance, based on unadjusted p-values
}
\description{
Implements an omics wide association study with the option of using the
'omics data as either the dependent variable (i.e., for performing an
exposure --> 'omics analysis) or using the 'omics as the independent
variable (i.e., for performing an 'omics --> outcome analysis). Allows for
either continuous or dichotomous outcomes, and provides the option to
adjust for covariates.
}
