% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valid_nhs.R
\name{valid_nhs}
\alias{valid_nhs}
\title{NHS Number Validity Check}
\usage{
valid_nhs(nhs_number)
}
\arguments{
\item{nhs_number}{a vector}
}
\value{
a vector, 1 if NHS number is valid, 0 if not valid
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Check if NHS numbers are valid based on the checksum algorithm

This uses the first 9 digits, multiplied by 10 down to 2 eg digit 1x10, d2x9

The sum of the products of the first 9 digits are divided by 11

The remainder is checked against the 10th digit

Where the remainder is 11, it is replaced with 0
}
\examples{
test <- floor(runif(1000,1000000000,9999999999))
valid_nhs(test)
valid_nhs(9434765919)
}
