% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{pub_kcdc_ili}
\alias{pub_kcdc_ili}
\title{KCDC ILI data}
\usage{
pub_kcdc_ili(
  regions,
  epiweeks,
  ...,
  issues = NULL,
  lag = NULL,
  fetch_args = fetch_args_list()
)
}
\arguments{
\item{regions}{character. Regions to fetch.}

\item{epiweeks}{\code{\link{timeset}}. Epiweeks to fetch.}

\item{...}{not used for values, forces later arguments to bind by name}

\item{issues}{\code{\link{timeset}}. Optionally, the issues to fetch. If not set, the
most recent issue is returned. Mutually exclusive with \code{lag}.}

\item{lag}{integer. Optionally, the lag of the issues to fetch. If not set,
the most recent issue is returned. Mutually exclusive with \code{issues}.}

\item{fetch_args}{\code{\link{fetch_args}}. Additional arguments to pass to \code{fetch()}.}
}
\value{
\code{\link[tibble:tibble]{tibble::tibble}}
}
\description{
API docs: \url{https://cmu-delphi.github.io/delphi-epidata/api/kcdc_ili.html}
}
\examples{
\dontrun{
pub_kcdc_ili(regions = "ROK", epiweeks = 200436)
}
}
\keyword{endpoint}
