% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{pub_covid_hosp_facility}
\alias{pub_covid_hosp_facility}
\title{COVID hospitalization data for specific facilities}
\usage{
pub_covid_hosp_facility(
  hospital_pks,
  collection_weeks,
  ...,
  publication_dates = NULL,
  fetch_args = fetch_args_list()
)
}
\arguments{
\item{hospital_pks}{character. Facility identifiers.}

\item{collection_weeks}{\code{\link{timeset}}. Epiweeks to fetch.}

\item{...}{not used for values, forces later arguments to bind by name}

\item{publication_dates}{\code{\link{timeset}}. Publication dates to fetch.}

\item{fetch_args}{\code{\link{fetch_args}}. Additional arguments to pass to \code{fetch()}.}
}
\value{
\code{\link[tibble:tibble]{tibble::tibble}}
}
\description{
API docs:
\url{https://cmu-delphi.github.io/delphi-epidata/api/covid_hosp_facility.html}

Obtains the COVID-19 reported patient impact and hospital capacity data by
facility. This dataset is provided by the US Department of Health & Human
Services. The companion function \code{\link[=pub_covid_hosp_facility_lookup]{pub_covid_hosp_facility_lookup()}} can be
used to look up facility identifiers in a variety of ways.
}
\details{
Starting October 1, 2022, some facilities are only required to
report annually.
}
\examples{
\dontrun{
pub_covid_hosp_facility(
  hospital_pks = "100075",
  collection_weeks = epirange(20200101, 20200501)
)
}
}
\seealso{
\code{\link[=pub_covid_hosp_facility]{pub_covid_hosp_facility()}}, \code{\link[=epirange]{epirange()}}
}
\keyword{endpoint}
