% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rtoolkit.R, R/quality.r
\name{ENgetqualtype}
\alias{ENgetqualtype}
\title{Retrieve the type of water quality analysis called for.}
\usage{
ENgetqualtype()

ENgetqualtype()
}
\value{
A named integer vector, the water quality analysis code (see below) and
  the index of node traced in a source tracing analysis.

list of qualcode and trace node
}
\description{
\code{ENgetqualtype} retrieves the type of water quality analysis called for.
}
\note{
Water quality analysis codes are as follows: 
  \tabular{lll}{
		\code{EN_NONE}  \tab  0  \tab  No quality analysis\cr
		\code{EN_CHEM}  \tab  1  \tab  Chemical analysis\cr
		\code{EN_AGE}   \tab  2  \tab  Water age analysis\cr
		\code{EN_TRACE} \tab  3  \tab  Source tracing
  }

  The tracenode value will be 0 when the quality code is not \code{EN_TRACE}.
}
\examples{
# path to Net1.inp example file included with this package
inp <- file.path( find.package("epanet2toolkit"), "extdata","Net1.inp")  
ENopen( inp, "Net1.rpt")
ENgetqualtype()
ENclose()
inp <- file.path( find.package("epanet2toolkit"), "extdata","Net1.inp")  
ENopen( inp, "Net1.rpt")
ENgetqualtype()
ENclose()
# clean-up the created files
file.remove("Net1.rpt") 
}
\seealso{
\code{ENsetqualtype}
}
