% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verifyFileStructure.R
\name{verifyFileStructure}
\alias{verifyFileStructure}
\title{Verify File Structure}
\usage{
verifyFileStructure(path, returnFileNames = TRUE, rasterExt = ".tif")
}
\arguments{
\item{path}{path to directory of rasters}

\item{returnFileNames}{logical, should file paths and names be returned}

\item{rasterExt}{file extension of rasters}
}
\value{
Prints messages to the console if problems are found. 
If \code{returnFileNames == TRUE}, then a vector of filenames is returned.
}
\description{
Ensures that the necessary files are present for other
functions to work properly.
}
\details{
This function searches for the following
in the directory specified by \code{path}:
		
12 precipitation rasters

12 min temperature rasters

12 max temperature rasters

12 mean temperature rasters [optional]

12 solar radiation rasters

The naming scheme will be checked against the one 
defined via the custom naming environment. See \code{link{?assignNames}}
for additional details.

An equivalent function for checking the names of rasters in R can be 
found at \code{\link{verifyRasterNames}}. 

The naming of the variables is defined by default as shown above. 
Changes to the naming scheme can easily be made. See \code{link{?assignNames}}
for more information.

If mean temperature rasters are not detected, the raster creation functions
will create mean temperature by taking the mean of the min and max.
}
\examples{
rasterPath <- system.file('extdata', package='envirem')
list.files(rasterPath)

# Assign naming scheme
assignNames(precip = 'prec_##')
varnames()

# As there are no problems with these files, the list of files 
# will be returned.
verifyFileStructure(rasterPath)

assignNames(reset = TRUE)
}
\author{
Pascal Title
}
