% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xcmsplus.R
\name{getfeaturest}
\alias{getfeaturest}
\title{Get the features from t test, with p value, q value, rsd and power restriction}
\usage{
getfeaturest(xod, power = 0.8, pt = 0.05, qt = 0.05, n = 3, rsdt = 30)
}
\arguments{
\item{xod}{xcmsSet objects}

\item{power}{defined power}

\item{pt}{p value threshold}

\item{qt}{q value threshold, BH adjust}

\item{n}{sample numbers in one group}

\item{rsdt}{rsd threshold to filter the data}
}
\value{
dataframe with peaks fit the setting above
}
\description{
Get the features from t test, with p value, q value, rsd and power restriction
}
\examples{
\dontrun{
library(faahKO)
cdfpath <- system.file("cdf", package = "faahKO")
xset <- getdata(cdfpath, pmethod = ' ')
getfeaturest(xset)
}
}
