% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recplot2.R
\name{enve.recplot2.extractWindows}
\alias{enve.recplot2.extractWindows}
\title{Enveomics: Recruitment Plot (2) Extract Windows}
\usage{
enve.recplot2.extractWindows(
  rp,
  peak,
  lower.tail = TRUE,
  significance = 0.05,
  seq.names = FALSE
)
}
\arguments{
\item{rp}{Recruitment plot, a \code{\link{enve.RecPlot2}} object.}

\item{peak}{Peak, an \code{\link{enve.RecPlot2.Peak}} object. If list, it is assumed to
be a list of \code{\link{enve.RecPlot2.Peak}} objects, in which case the core
peak is used (see \code{\link{enve.recplot2.corePeak}}).}

\item{lower.tail}{If \code{FALSE}, it returns windows significantly above the peak in
sequencing depth.}

\item{significance}{Significance threshold (alpha) to select windows.}

\item{seq.names}{Returns subject sequence names instead of a vector of Booleans. If
the recruitment plot was generated with named position bins (e.g, using
\code{pos.breaks=0} or a two-column \code{pos.breaks.tsv}), it returns a
vector of characters (the sequence identifiers), otherwise it returns a
data.frame with a name column and two columns of coordinates.}
}
\value{
Returns a vector of logicals if \code{seq.names = FALSE}.
If \code{seq.names = TRUE}, it returns a data.frame with five columns:
\code{name.from}, \code{name.to}, \code{pos.from}, \code{pos.to}, and
\code{seq.name} (see \code{\link{enve.recplot2.coordinates}}).
}
\description{
Extract windows significantly below (or above) the peak in sequencing
depth.
}
\author{
Luis M. Rodriguez-R [aut, cre]
}
