% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/texture.R
\name{texture}
\alias{texture}
\alias{print.texture}
\alias{plot.texture}
\title{ASTM soil texture analysis}
\usage{
texture(time, reading, blank, temp, data, conc = 50, Gs = 2.65,
  hydrometer = "auto", model = "auto", plot = F)

\method{print}{texture}(x, ...)

\method{plot}{texture}(x, ...)
}
\arguments{
\item{time}{a numeric vector or data frame object containing the time passed
since the beginning of the measurement in minutes}

\item{reading}{a numeric vector or data frame object providing the actual
hydrometer readings at the bottom of the meniscus}

\item{blank}{a numeric vector or data frame object containing the blank
readings taken in 5 g/L sodium hexametaphosphate solution (composite correction)}

\item{temp}{an integer vector or data frame object containing the measured
temperature}

\item{data}{a data frame containing the specified columns. If empty, data
need to be given as numeric vectors}

\item{conc}{the concentration of the soil solution, default = 50 g/L as
proposed in the ASTM guideline}

\item{Gs}{specific gravity of the suspension, default = 2.65}

\item{hydrometer}{a character sting specifying the hydrometer used. Accepted
values are \code{"auto"} for auto-detection (default), \code{"151H"}, and \code{"152H"}}

\item{model}{string is passed to \code{\link[drc]{drm}}, "auto" chooses the
best fitting model automatically}

\item{plot}{logical; if TRUE the particle size distribution is plotted}

\item{x}{an object of class "texture"}

\item{\dots}{further arguments to be passed to \code{print} or \code{plot}}
}
\value{
\code{texture} returns an object of \code{\link[base]{class}} "texture". The functions
\code{print} and \code{plot} are available to retrieve the soil texture classes
and the particle size distribution, respectively.

An object of class "texture" is a list containing the following components:
\tabular{ll}{
\code{meta} \tab Measurement meta data\cr
\code{distribution} \tab \code{data.frame} providing the particle size
distribution\cr
\code{model} \tab information on the fitted \code{\link[drc]{drm}} model\cr
\code{din} \tab Main DIN texture classes\cr
\code{usda} \tab Main USDA texture classes\cr
}
}
\description{
Calculates the particle size distribution and both DIN and USDA texture
classes from a series of hydrometer readings according to ASTM D422-63(2007)e2.
}
\examples{
data(clayloam)
texture(Time, Reading, Blank, Temperature, data = clayloam)

}
\references{
ASTM D422-63(2007)e2, 2007. Standard Test Method for Particle-Size Analysis
of Soils (Technical standard). ASTM International, West Conshohocken, PA.
Available from \url{http://www.astm.org/Standards/D422.htm}
}
