% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enspls.fs.R
\name{enspls.fs}
\alias{enspls.fs}
\title{Ensemble Sparse Partial Least Squares for Measuring Feature Importance}
\usage{
enspls.fs(x, y, maxcomp = 5L, cvfolds = 5L, alpha = seq(0.2, 0.8, 0.2),
  reptimes = 500L, method = c("mc", "boot"), ratio = 0.8, parallel = 1L)
}
\arguments{
\item{x}{Predictor matrix.}

\item{y}{Response vector.}

\item{maxcomp}{Maximum number of components included within each model.
If not specified, will use \code{5} by default.}

\item{cvfolds}{Number of cross-validation folds used in each model
for automatic parameter selection, default is \code{5}.}

\item{alpha}{Parameter (grid) controlling sparsity of the model.
If not specified, default is \code{seq(0.2, 0.8, 0.2)}.}

\item{reptimes}{Number of models to build with Monte-Carlo resampling
or bootstrapping.}

\item{method}{Resampling method. \code{"mc"} (Monte-Carlo resampling)
or \code{"boot"} (bootstrapping). Default is \code{"mc"}.}

\item{ratio}{Sampling ratio used when \code{method = "mc"}.}

\item{parallel}{Integer. Number of CPU cores to use.
Default is \code{1} (not parallelized).}
}
\value{
A list containing two components:
\itemize{
\item \code{variable.importance} - a vector of variable importance
\item \code{coefficient.matrix} - original coefficient matrix
}
}
\description{
Measuring feature importance with ensemble sparse partial least squares.
}
\examples{
data("logd1k")
x = logd1k$x
y = logd1k$y

set.seed(42)
fs = enspls.fs(x, y, reptimes = 5, maxcomp = 2)
print(fs, nvar = 10)
plot(fs, nvar = 10)
plot(fs, type = 'boxplot', limits = c(0.05, 0.95), nvar = 10)
}
\author{
Nan Xiao <\url{http://nanx.me}>
}
\seealso{
See \code{\link{enspls.od}} for outlier detection with
ensemble sparse partial least squares regressions.
See \code{\link{enspls.fit}} for fitting ensemble sparse
partial least squares regression models.
}

