% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enspls.od.R
\name{enspls.od}
\alias{enspls.od}
\title{Ensemble Sparse Partial Least Squares for Outlier Detection}
\usage{
enspls.od(x, y, maxcomp = 5L, alpha = seq(0.2, 0.8, 0.2), MCtimes = 500L,
  method = c("mc", "bootstrap"), ratio = 0.8, parallel = 1L)
}
\arguments{
\item{x}{predictor matrix}

\item{y}{response vector}

\item{maxcomp}{Maximum number of components included within the models,
if not specified, default is 5.}

\item{alpha}{Parameter (grid) controlling sparsity of the model.
If not specified, default is \code{seq(0.2, 0.8, 0.2)}.}

\item{MCtimes}{times of Monte-Carlo}

\item{method}{\code{"mc"} or \code{"bootstrap"}. Default is \code{"mc"}.}

\item{ratio}{sample ratio used when \code{method = "mc"}}

\item{parallel}{Integer. Number of CPU cores to use.
Default is \code{1} (not parallelized).}
}
\value{
A list containing four components:
\itemize{
\item \code{error.mean} - error mean for all samples (absolute value)
\item \code{error.median} - error median for all samples
\item \code{error.sd} - error sd for all samples
\item \code{predict.error.matrix} - the original prediction error matrix
}
}
\description{
Outlier detection with ensemble sparse partial least squares.
}
\note{
To maximize the probablity that each observation can
be selected in the test set (thus the prediction uncertainty
can be measured), please try setting a large \code{MCtimes}.
}
\examples{
data("logd1k")
x = logd1k$x
y = logd1k$y

set.seed(42)
od = enspls.od(x, y, MCtimes = 5, maxcomp = 3)
plot(od, prob = 0.1)
plot(od, criterion = "sd", sdtimes = 1)
}
\author{
Nan Xiao <\url{http://nanx.me}>
}
\seealso{
See \code{\link{enspls.fs}} for feature selection with
ensemble sparse partial least squares regression.
See \code{\link{enspls.fit}} for ensemble sparse
partial least squares regression.
}

