% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analytics.R
\name{count_authors}
\alias{count_authors}
\title{Count the number of topics by author, by theme and by date}
\usage{
count_authors(
  topics,
  by_theme = TRUE,
  by_date = c("month_year", "year", "all"),
  .sort = TRUE
)
}
\arguments{
\item{topics}{A tibble of topics by theme from \strong{en-net} forum produced
through a call to \code{\link[=get_themes_topics]{get_themes_topics()}}.}

\item{by_theme}{Logical. If \emph{TRUE (default)}, count by theme.}

\item{by_date}{Should topics be counted by month of the year or just by
year or total? Default is to count by month of the year.}

\item{.sort}{Logical. Should output be sorted by count frequencies? Default
is \emph{TRUE}.}
}
\value{
A tibble of topic counts by author, by theme and by specified date
format
}
\description{
Count the number of topics by author, by theme and by date
}
\examples{
library(magrittr)
ennet_topics \%>\% count_authors()

}
\author{
Ernest Guevarra
}
