% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to-encoding.R
\name{to_encoding}
\alias{to_encoding}
\alias{to_utf8}
\alias{to_native}
\alias{to_latin1}
\alias{to_alien}
\alias{to_encoding.character}
\title{Deep conversion to an encoding}
\usage{
to_encoding(x, ...)

to_utf8(x, ...)

to_native(x, ...)

to_latin1(x, ...)

to_alien(x, ...)

\method{to_encoding}{character}(x, ..., converter)
}
\arguments{
\item{x}{A character vector.}

\item{...}{passed on to methods}

\item{converter}{A function that accepts a character value as first argument
and returns a (possibly classed) character with the desired encoding}
}
\description{
Converts all characters directly or indirectly contained in an object to
a specific encoding.
This works even if the encoding is different in the elements of a character
vector.
}
\details{
\describe{
\item{\code{to_utf8}}{converts to UTF-8, using the \code{\link[=utf8]{utf8()}} class
where possible. Implemented as \code{to_encoding(x, as_utf8)}}
\item{\code{to_native}}{converts to the native encoding.
Implemented as \code{to_encoding(x, enc2native)} on Windows
and as \code{to_encoding(x, as_utf8)} on Linux and OS X}
\item{\code{to_latin1}}{converts to the latin-1 encoding}
\item{\code{to_alien}}{converts to the "other" encoding, i.e.,
UTF-8 on Windows and latin-1 on Linux and OS X.}
}
}
\examples{
to_utf8(letters)
to_utf8(iris)
class(levels(to_utf8(iris)$Species))
}
\seealso{
\itemize{
\item \code{\link[rlang:as_utf8_character]{rlang::as_utf8_character()}} and \code{\link[=iconv]{iconv()}} for different ways to convert
character vectors to Unicode
}
}
