% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unpack.R
\name{unpack}
\alias{unpack}
\title{Extracts network object into a list}
\usage{
unpack(x = "network object")
}
\arguments{
\item{x}{A network object.  This includes all weighted flows into and out of
each node.}
}
\value{
\item{F}{matrix of flows from each node to each node oreinted row to
column.} \item{z}{Node boundary inputs.} \item{r}{Node boundary loss from
respiration.} \item{e}{Node boundary loss due to exportation} \item{y}{Node
boundary loss; summation of r and e} \item{X}{Node storage or biomass}
\item{living}{Logical vector indicating whether each node is living or not}
}
\description{
Separates the components of a network object into separate
components within a list. This includes inputs, exports,
respirations, outputs (exports + respirations), storage, and internal flows.
}
\details{
Flows are oriented from row to column.
}
\examples{
data(troModels)
unpack(troModels[[6]])

}
\seealso{
\code{\link{pack},\link{read.scor}}
}
\author{
Matthew K. Lau Stuart R. Borrett
}
