% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-annotations_crud.R
\name{create_itemsInLevel}
\alias{create_itemsInLevel}
\title{Create new items programmatically}
\usage{
create_itemsInLevel(emuDBhandle, itemsToCreate, rewriteAllAnnots = TRUE,
  verbose = TRUE)
}
\arguments{
\item{emuDBhandle}{emuDB handle as returned by \code{\link{load_emuDB}}}

\item{itemsToCreate}{A data frame with the columns
\itemize{
\item\code{session},
\item\code{bundle},
\item\code{level},
\item\code{start_item_seq_idx}(\code{start_item_seq_idx} is used instead of 
\code{seq_idx} so that the result of a \code{\link{query}} call can be used directly. 
\code{\link{query}} can return a sequence of items defined by \code{start_item_seq_idx} 
and \code{end_item_seq_idx} which have the same value if single items are returned),
\item\code{attribute}, and
\item \code{labels}.
}
*None* of the columns should be factors.
\code{sequenceIndex} must be numeric (can be real-valued or natural-valued),
all other columns must be of type character.}

\item{rewriteAllAnnots}{should changes be written to file system (_annot.json
files) (intended for expert use only)}

\item{verbose}{if set to \code{TRUE}, more status messages are printed}
}
\description{
Allows creating annotation items programmatically on a single level. 
You have to pass in a data frame describing the new items. Each new item is identified by
its \code{session}, \code{bundle}, \code{level}, and depending on the 
level type either:

\itemize{
\item \code{sequence index (start_item_seq_idx)}: when level type = \code{ITEM}
\item \code{start}: start time in ms * 1000 (see output of \link{query}) when level type = \code{EVENT}
\item \code{start} and \code{end}: start and end time in ms * 1000 () when level type = \code{SEGMENT} (currently not yet supported!)
} 
.
The \code{level} with its associated \code{attributes} determines how many
labels must be provided. You must provide a label for every existing attribute.

Sessions, bundles, levels and attributes must exist beforehand. The sequence
index is explained below.

Within each bundle, there can be multiple annotation items on every level.
Their order within the level is given by their sequence index. All *existing*
items have a natural-valued sequence index and there are no gaps in the
sequences (i.e. if a level contains n annotation items, they are indexed 1..n).

Any newly created item must be given a sequence index. The sequence index may
be real-valued (it will automatically be replaced with a natural value). To
prepend the new item to the existing one, pass a value lower than one. To
append it to the existing items, you can either pass \code{NA} or any value
that you know is greater than n (the number of existing items in that level).
It does not need to be exactly n+1. To place the new item between two
existing ones, use any real value between the sequence indexes of the existing
neighbors.

If you are appending multiple items at the same time, every sequence index
(including NA) can only be used once per session/bundle/level combination
(because session/bundle/level/sequence index are a unique identifier of an item's ).

After creating the items, all sequence indexes (which may now be real-valued,
natural-valued or NA) are sorted in ascending order and then replaced with
the values 1..n, where n is the number of items on that level. While sorting,
NA values are placed at the end.

Currently it is not possible to insert items into levels of type SEGMENT.
}
