% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-database.DBconfig.R
\name{AddListRenameRemoveAttributeDefinitions}
\alias{AddListRenameRemoveAttributeDefinitions}
\alias{add_attributeDefinition}
\alias{list_attributeDefinitions}
\alias{remove_attributeDefinition}
\alias{rename_attributeDefinition}
\title{Add / List / Rename / Remove attribute definition to / of / from emuDB}
\usage{
add_attributeDefinition(emuDBhandle, levelName, name, type = "STRING",
  verbose = T)

list_attributeDefinitions(emuDBhandle, levelName)

rename_attributeDefinition(emuDBhandle, origAttrDef, newAttrDef, verbose = T)

remove_attributeDefinition(emuDBhandle, levelName, name, verbose = T)
}
\arguments{
\item{emuDBhandle}{emuDB handle as returned by \code{\link{load_emuDB}}}

\item{levelName}{name of level}

\item{name}{name of attributeDefinition}

\item{type}{type of attributeDefinition (currently only "STRING")}

\item{verbose}{if set to \code{TRUE}, more status messages are printed}

\item{origAttrDef}{name of level/attribute definition in emuDB that is to be changed}

\item{newAttrDef}{new name that shall be assigned to the level/attribute definition}
}
\description{
Add / List / Rename / Remove database operation functions for attribute
definition to / of / from an existing level definition of an emuDB.
Attribute definitions can be viewed as definitions of
parallel labels for the annotational units (ITEMs) of the emuDB. 
Each level definition is required to have at least one 
default attribute definition that has the same name as the level definition
(automatically created by \code{\link{add_levelDefinition}}). For more 
information on the structural elements of an emuDB see \code{vignette(emuDB)}.
Note that as with level definitions, an attribute definition to a level cannot be removed,
if it contains labels in the emuDB.

As the only one of these operations, \code{rename_attributeDefinition} can
also be used to manipulate (i.e. rename) a level definition. It is therefore
not necessary to specify the name of the level that the attribute definition
belongs to. While renaming a level or attribute definition, emuR will
(1) rewrite the levelDefinitions in DBconfig, (2) rewrite the
linkDefinitions in DBconfig, (3) rewrite the perspectives in DBconfig,
(4) rewrite the anagestConfig in DBconfig, and (5) rewrite all _annot.json
files. (5) May take quite a while, depending on the number of bundles in the
database.
}
\examples{
\dontrun{

##################################
# prerequisite: loaded ae emuDB 
# (see ?load_emuDB for more information)

# add additional attribute definition to the "Phonetic" level
# of the ae emuDB that will contain the UTF8 IPA
# symbols of the phonetic transcriptions
add_attributeDefinition(emuDBhandle = ae,
                        levelName = "Phonetic",
                        name = "IPA-UTF8")
                        
# list attribute definitions for level "Word"
# of the ae emuDB
list_attributeDefinitions(emuDBhandle = ae, 
                          levelName = "Word")

# remove newly added attributeDefinition
remove_attributeDefinition(emuDBhandle = ae,
                           levelName = "Phonetic",
                           name = "IPA-UTF8")
}

}
\keyword{DBconfig}
\keyword{Emu}
\keyword{database}
\keyword{emuDB}

