#' German Breast Cancer Dataset
#'
#' A dataset containing variables related with breast cancer from german population.
#'
#' \itemize{
#'   \item \code{age} Patient age (years).
#'   \item \code{meno} Menopausal status (0 = premeno, 1 = postmeno).
#'   \item \code{size} Tumour size (mm).
#'   \item \code{gradd1} 1 = tumour grade 2 or 3; 0 = grade 1.
#'   \item \code{gradd2} 1 = tumour grade 3; 0 = grade 1 or 2.
#'   \item \code{nodes} Number of positive lymph nodes.
#'   \item \code{enodes} emp(-0.12 x \code{nodes}).
#'   \item \code{pgr} Progesterone receptor status (fmol 1^-1).
#'   \item \code{er} Oestrogen reeceotor status (fmol 1^-1).
#'   \item \code{hormon} Tamoxifen treatment (0 = no; 1 = yes).
#'   \item \code{rectime} Time (days) to death or cancer recurrence.
#'   \item \code{censrec} Censoring (0 = censored; 1 = event).
#' }
#'
#' @format A data frame with 686 rows and 14 variables
#' @source http://biostat.mc.vanderbilt.edu/wiki/Main/DataSets
"breastCancer"
#>[1]"breastCancer"
