% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlme_methods.R
\name{intervals}
\alias{intervals}
\alias{intervals.ebp}
\alias{intervals.fh}
\title{Confidence intervals on coefficients of an emdi object}
\usage{
\method{intervals}{ebp}(object, level = 0.95, parm = NULL, ...)

\method{intervals}{fh}(object, level = 0.95, parm = NULL, ...)
}
\arguments{
\item{object}{an object of type "emdi", depending on the method either "ebp" 
or "fh".}

\item{level}{an optional numeric value with the confidence level for the intervals. 
Defaults to 0.95.}

\item{parm}{vector of names to specify which parameters are to be given confidence 
intervals. If \code{NULL}, all parameters are taken into account. Defaults to \code{NULL}.}

\item{...}{additional arguments that are not used in this method.}
}
\value{
A matrix with rows corresponding to the parameters and columns 
containing the lower confidence limits (lower), the 
estimated values (est.), and upper confidence limits (upper).
}
\description{
Methods \code{intervals.ebp} and \code{intervals.fh} provide the approximate 
confidence intervals on the coefficients (fixed effects) of an emdi object.
}
\details{
The generic function \code{intervals} is imported from package nlme and 
re-exported to make the S3-methods available, even though the nlme package 
itself is not loaded or attached. For default documentation, 
see \code{\link[nlme]{intervals}}.
}
\examples{
\donttest{
# Example for class ebp
emdi_model <- ebp(fixed = eqIncome ~ gender + eqsize + cash + self_empl + 
unempl_ben + age_ben + surv_ben + sick_ben + dis_ben + rent + fam_allow + 
house_allow + cap_inv + tax_adj, pop_data = eusilcA_pop, 
pop_domains = "district", smp_data = eusilcA_smp, smp_domains = "district", 
na.rm = TRUE)

intervals(emdi_model)
}
}
\seealso{
\code{\link{direct}}, \code{\link{ebp}}, \code{\link{fh}}, \code{\link[nlme]{intervals}}
}
