% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.emdi.R
\name{plot.emdi}
\alias{plot.emdi}
\title{Plots for an emdi object}
\usage{
\method{plot}{emdi}(x, label = "orig", color = c("blue", "lightblue3"),
  gg_theme = NULL, cooks = TRUE, range = NULL, ...)
}
\arguments{
\item{x}{an object of type "emdi", representing point and MSE
estimates.}

\item{label}{argument that enables to customize title and axis labels. There 
are four options to label the diagsnostic plot: (i) original labels ("orig"), 
(ii) axis lables but no title ("no_title"), (iii) neither axis 
labels nor title ("blank"), (iv) individual labels by a list that needs to 
have below structure. Six elements can be defined called \code{qq_res, qq_ran, 
d_res, d_ran, cooks} and \code{box_cox} for the six different plots and these 
list elements need to have three elements each called \code{title, y_lab and 
x_lab}. Only the labels for the plots that should be different to the original
need to be specified. \cr
list(
\describe{
\item{qq_res =}{c(title="Error term", y_lab="Quantiles of pearson residuals", 
                x_lab="Theoretical quantiles"),}
\item{qq_ran =}{c(title="Random effect",
                y_lab="Quantiles of random effects", 
                x_lab="Theoretical quantiles"),}
\item{d_res =}{c(title="Density - Pearson residuals", 
               y_lab="Density", 
               x_lab="Pearson residuals"),}
\item{d_ran =}{c(title="Density - Standardized random effects",
               y_lab="Density", 
               x_lab="Standardized random effects"),}
\item{cooks =}{c(title="Cook's Distance Plot", 
               y_lab="Cook's Distance", 
               x_lab="Index"),}
\item{box_cox =}{c(title="Box-Cox - REML", 
               y_lab="Log-Likelihood", 
               x_lab="expression(lambda)"))}
}}

\item{color}{a character vector with two elements. The first element defines
the color for the line in the QQ-plots, for the Cook's Distance plot and for
the Box-Cox plot. The second element define the color for the densities.}

\item{gg_theme}{\code{\link[ggplot2]{theme}} list from package \pkg{ggplot2}.}

\item{cooks}{if TRUE, a Cook's distance plot is returned. The used method
\code{\link[HLMdiag]{cooks.distance.lme}} struggles when data sets get large.
In these cases, \code{cooks} should be set to \code{FALSE}. It defaults to 
\code{TRUE}.}

\item{range}{optional sequence determining the range of the x-axis for plots
of the optimal parameter that defaults to NULL. In that case a range of the
optimal parameter +2/-1 is used for the plots of the optimal parameter. This
leads in some cases to convergence problems such that is should be changed to
e.g. the selected \code{interval}. This means for the default seq(-1,2,by=0.05).}

\item{...}{optional arguments passed to generic function.}
}
\value{
one line plot for the optimal parameter and two density plots
obtained by \code{\link{ggplot}}.
}
\description{
Plots of the optimal parameter in Box-Cox transformations and density plots
of residuals and random effects from the nested error regression model are
obtained. The return depends on the transformation such that a plot for the
optimal parameter is only returned in case a Box-Cox transformation is chosen.
The range of the x-axis is optional but necessary to change if
there are convergence problems. The density plots are obtained by
\code{\link{ggplot}} using Pearson residuals and random effects. Function
\code{generic_opt} is used for obtaining \code{\link{ggplot}} plots for the
optimal parameter.
}
\examples{
\dontrun{
# Loading data - population and sample data
data("eusilcA_pop")
data("eusilcA_pop")

# Example with default setting but na.rm=TRUE; with Box-Cox transformation
set.seed(100); emdi_model <- ebp( fixed = eqIncome ~ gender + eqsize + cash + 
self_empl + unempl_ben + age_ben + surv_ben + sick_ben + dis_ben + rent + 
fam_allow + house_allow + cap_inv + tax_adj, pop_data = eusilcA_pop,
pop_domains = "district", smp_data = eusilcA_smp, smp_domains = "district",
L= 1, na.rm = TRUE)

# Creation of default diagnostic plots
plot(emdi_model)

# Creation of diagnostic plots without labels and titles, different colors 
# and without Cook's distance plot.
plot(emdi_model, label="no_title", color=c("red", "yellow"), cooks = FALSE)
}
}
\seealso{
\code{\link{emdiObject}}, \code{\link{ebp}}
}

