% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initializers.R
\name{init.fit}
\alias{init.fit}
\title{Method to initialize EM parameters.  Carries out a single GLM fit and applies random noise to form starting space.}
\usage{
init.fit(y, x, K, weight = c(1), family = poisson(), noise = 1)
}
\arguments{
\item{y}{A vector of observation of length \emph{n}.}

\item{x}{An \emph{n}-by-\emph{p} design matrix.}

\item{K}{Number of EM classes to be fit.}

\item{weight}{A \emph{n} length vector of observation weight terms.  This is currently designed to be either the exposure for a Poisson model or the number of trials for a Logistic model.}

\item{family}{GLM family to fit.}

\item{noise}{Standard deviation of the white noise to be applied when generating random initial states.}
}
\value{
A K-length list, each holding parameters.
}
\description{
Method to initialize EM parameters.  Carries out a single GLM fit and applies random noise to form starting space.
}
\examples{
x <- model.matrix(~ 1 + factor(wool) + factor(tension), data = warpbreaks)
y <- warpbreaks$breaks

init.fit(y = y, x = x, K = 2)

}
