% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elo.run.R, R/elo.run2.R
\name{elo.run}
\alias{elo.run}
\alias{elo.run2}
\title{\code{elo.run}}
\usage{
elo.run(formula, data, na.action, subset, k = NULL, initial.elos = NULL, ...)

elo.run2(
  formula,
  data,
  na.action,
  subset,
  k = NULL,
  initial.elos = NULL,
  ...,
  prob.fun = elo.prob,
  update.fun = elo.update
)
}
\arguments{
\item{formula}{A formula. See \link[=formula.specials]{the help page for formulas} for details.}

\item{data}{A \code{data.frame} in which to look for objects in \code{formula}.}

\item{na.action}{A function which indicates what should happen when the data contain NAs.}

\item{subset}{An optional vector specifying a subset of observations.}

\item{k}{A constant k-value (or a vector, where appropriate).}

\item{initial.elos}{An optional named vector containing initial Elo ratings for all teams in \code{formula}.}

\item{...}{Other arguments (not used at this time).}

\item{prob.fun}{A function with at least 4 arguments: elo.A, elo.B, adjust.A, and adjust.B. It should return a predicted probability
that team A wins. The values passed in will be scalars, and a scalar is expected as output.}

\item{update.fun}{A function with at least 6 arguments: the same as \code{\link{elo.update.default}}. The function takes
in the Elos, the win indicator, k, and any adjustments, and returns a value by which to update the Elos. The values passed in
will be scalars, and a scalar is expected as output.}
}
\value{
An object of class \code{"elo.run"} or class \code{"elo.run.regressed"}.
}
\description{
Calculate Elos for a series of matches.
}
\details{
\code{elo.run} and \code{elo.run2} by default return the exact same thing. \code{elo.run} uses C++ and may be up to 50 times faster,
  while \code{elo.run2} uses R but also supports custom update functions. Prefer the first unless you really need a custom update function.
}
\examples{
data(tournament)
elo.run(score(points.Home, points.Visitor) ~ team.Home + team.Visitor,
        data = tournament, k = 20)

# Create non-constant 'k'
elo.run(score(points.Home, points.Visitor) ~ team.Home + team.Visitor +
        k(20*log(abs(points.Home - points.Visitor) + 1)), data = tournament)

# Adjust Elo for, e.g., home-field advantage
elo.run(score(points.Home, points.Visitor) ~ adjust(team.Home, 30) + team.Visitor,
        data = tournament, k = 20)

tournament$home.field <- 30
elo.run(score(points.Home, points.Visitor) ~ adjust(team.Home, home.field) + team.Visitor,
        data = tournament, k = 20)

# Regress the Elos back toward 1500 at the end of the half-season
elo.run(score(points.Home, points.Visitor) ~ adjust(team.Home, 30) +
        team.Visitor + regress(half, 1500, 0.2), data = tournament, k = 20)

}
\seealso{
\code{\link{score}}, \link{elo.run.helpers}{elo.run helpers}, \code{\link{elo.calc}},
  \code{\link{elo.update}}, \code{\link{elo.prob}}, \code{\link{elo.model.frame}}.
}
