% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seats_fed.R
\name{seats_fed}
\alias{seats_fed}
\title{Download data on the number of seats under dispute in federal elections}
\usage{
seats_fed(year, uf = "all", br_archive = FALSE, ascii = FALSE,
  encoding = "latin1", export = FALSE)
}
\arguments{
\item{year}{Election year. For this function, only the years of 1996, 2000, 2004, 2008, 2012 and 2016
are available.}

\item{uf}{Federation Unit acronym (\code{character} vector).}

\item{br_archive}{In the TSE's data repository, some results can be obtained for the whole country by loading a single
within a single file by setting this argument to \code{TRUE} (may not work in for some elections and, in 
other, it recoverns only electoral data for presidential elections, absent in other files).}

\item{ascii}{(\code{logical}). Should the text be transformed from Latin-1 to ASCII format?}

\item{encoding}{Data original encoding (defaults to 'Latin-1'). This can be changed to avoid errors
when \code{ascii = TRUE}.}

\item{export}{(\code{logical}). Should the downloaded data be saved in .dta and .sav in the current directory?}
}
\value{
\code{seats_fed()} returns a \code{data.frame} with the following variables:

\itemize{
  \item DATA_GERACAO: Generation date of the file (when the data was collected).
  \item HORA_GERACAO: Generation time of the file (when the data was collected), Brasilia Time.
  \item ANO_ELEICAO: Election year.
  \item DESCRICAO_ELEICAO: Description of the election.
  \item SIGLA_UF: Units of the Federation's acronym in which occurred the election.
  \item SIGLA_UE: Units of the Federation's acronym (In case of major election is the FU's 
  acronym in which the candidate runs for (text) and in case of municipal election is the
  municipal's Supreme Electoral Court code (number)). Assume the special values BR, ZZ and
  VT to designate, respectively, Brazil, Overseas and Absentee Ballot.
  \item NOME_UE: Description of the Electoral Unit.
  \item CODIGO_CARGO: Code of the position that the candidate runs for.
  \item DESCRICAO_CARGO: Description of the position that the candidate runs for.
  \item QTDE_VAGAS: number of seats under dispute.
}
}
\description{
\code{seats_fed()} downloads and aggregates data on the number of seats under dispute in
federal elections in Brazil. The function returns a \code{tbl, data.frame} where each observation
corresponds to a district-office dyad.
}
\details{
If export is set to \code{TRUE}, the downloaded data is saved as .dta and .sav
 files in the current directory.
}
\note{
For the elections prior to 2000, some information can be incomplete.
}
\examples{
\dontrun{
df <- seats_fed(2000)
}
}
\seealso{
\code{\link{seats_local}} for local elections in Brazil.
}
