% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/mapping.R
\name{mapping}
\alias{field_mapping_get}
\alias{mapping}
\alias{mapping_create}
\alias{mapping_delete}
\alias{mapping_get}
\alias{type_exists}
\title{Mapping management}
\usage{
mapping_create(index, type, body, ...)

mapping_delete(index, type, ...)

mapping_get(index = NULL, type = NULL, ...)

field_mapping_get(index = NULL, type = NULL, field,
  include_defaults = FALSE, ...)

type_exists(index, type, ...)
}
\arguments{
\item{index}{(character) An index}

\item{type}{(character) A document type}

\item{body}{(list) Either a list or json, representing the query.}

\item{...}{Curl options passed on to \code{\link[httr]{HEAD}} or other http verbs}

\item{field}{(character) One or more field names}

\item{include_defaults}{(logical) Whether to return default values}
}
\description{
Mapping management
}
\details{
Find documentation for each function at:
\itemize{
 \item mapping_create - \url{http://bit.ly/1xbWqFo}
 \item type_exists - \url{http://bit.ly/10HkZvH}
 \item mapping_delete - \url{http://bit.ly/10Mmvgi}
 \item mapping_get - \url{http://bit.ly/1AN2oiw}
 \item field_mapping_get - \url{http://bit.ly/1wHKgCA }
}

\strong{NOTE:} For the delete method, Elasticsearch documentation notes that: "... most times,
it make more sense to reindex the data into a fresh index compared to delete large chunks of it."
}
\examples{
\dontrun{
# Used to check if a type/types exists in an index/indices
type_exists(index = "plos", type = "article")
type_exists(index = "plos", type = "articles")
type_exists(index = "shakespeare", type = "line")

# The put mapping API allows to register specific mapping definition for a specific type.
## a good mapping body
body <- list(citation = list(properties = list(
 journal = list(type="string"),
 year = list(type="long")
)))
mapping_create(index = "plos", type = "citation", body=body)

### or as json
body <- '{
  "citation": {
    "properties": {
      "journal": { "type": "string" },
      "year": { "type": "long" }
}}}'
mapping_delete("plos", "citation")
mapping_create(index = "plos", type = "citation", body=body)
mapping_get("plos", "citation")

## A bad mapping body
body <- list(things = list(properties = list(
  journal = list("string")
)))
mapping_create(index = "plos", type = "things", body=body)

# Delete a mapping
mapping_delete("plos", "citation")

# Get mappings
mapping_get('_all')
mapping_get(index = "plos")
mapping_get(index = c("shakespeare","plos"))
mapping_get(index = "shakespeare", type = "act")
mapping_get(index = "shakespeare", type = c("act","line"))

# Get field mappings
field_mapping_get(index = "_all", type=c('article','line'), field = "text")
field_mapping_get(index = "plos", type = "article", field = "title")
field_mapping_get(index = "plos", type = "article", field = "*")
field_mapping_get(index = "plos", type = "article", field = "title", include_defaults = TRUE)
field_mapping_get(type = c("article","record"), field = c("title","class"))
field_mapping_get(type = "a*", field = "t*")

# Create geospatial mapping
docs_bulk("inst/examples/gbif_geopoint.json")
body <- '{
 "pin" : {
   "properties" : {
     "location" : { "type" : "geo_point" }
   }
 }
}'
mapping_create("gbifgeopoint", "record", body=body)
}
}

