% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.eirm.R
\name{print.eirm}
\alias{print.eirm}
\title{Printing Estimated Parameters for Explanatory IRT Models}
\usage{
\method{print}{eirm}(x, difficulty = FALSE, ...)
}
\arguments{
\item{x}{An object returned from the \code{\link{eirm}} function.}

\item{difficulty}{Whether difficulty should be used instead of easiness (default: FALSE)}

\item{...}{Other print-related arguments.}
}
\value{
Estimated parameters from an eirm object.
}
\description{
This generic function prints estimated parameters from an eirm object returned
from the \code{\link{eirm}} function.
}
\examples{
data("VerbAgg")
mod0 <- eirm(formula = "r2 ~ -1 + situ + btype + (1|id)", data = VerbAgg)
print(mod0) # or, just mod0
print(mod0, difficulty = TRUE)
}
