% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.eirm.R
\name{plot.eirm}
\alias{plot.eirm}
\title{Person-Item Map for Explanatory IRT Models}
\usage{
\method{plot}{eirm}(
  x,
  difficulty = FALSE,
  sorted = TRUE,
  theta = NULL,
  main = "Person-Item Map",
  latdim = "Latent Dimension",
  pplabel = "Person\\nParameter\\nDistribution",
  cex.gen = 0.7,
  ...
)
}
\arguments{
\item{x}{An object returned from the \code{\link{eirm}} function.}

\item{difficulty}{Whether difficulty should be used instead of easiness (default: FALSE).}

\item{sorted}{Whether the parameters should be sorted in the plot (default: TRUE).}

\item{theta}{A vector of estimated theta values. If NULL, then theta values are obtained from the
estimated eirm model. It might be better to save the theta values from a baseline model (e.g., Rasch)
and use them when creating a person-item map.}

\item{main}{Main title for the person-item map.}

\item{latdim}{Label of the x-axis, i.e., the latent dimension.}

\item{pplabel}{Title for the upper panel displaying the person parameter distribution.}

\item{cex.gen}{A numerical value giving the amount by which plotting text and symbols should
be magnified relative to the default. Here cex.gen applies to all text labels. The default is 0.7.}

\item{...}{Other plot-related arguments.}
}
\value{
A person-item map.
}
\description{
This function creates a person-item map for an object returned from the \code{\link{eirm}} function.
The function was modified from \code{\link[eRm]{plotPImap}} in package \pkg{eRm}.
}
\examples{
data("VerbAgg")
mod0 <- eirm(formula = "r2 ~ -1 + situ + btype + (1|id)", data = VerbAgg)
plot(mod0)
plot(mod0, difficulty = TRUE) # Plot difficulty instead of easiness
}
