% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustered.graphs.R
\name{clustered_graphs}
\alias{clustered_graphs}
\alias{clustered_graphs.list}
\alias{clustered_graphs.egor}
\alias{clustered_graphs.data.frame}
\title{Cluster ego-centered networks by a grouping factor}
\usage{
clustered_graphs(object, ..., clust.groups)

\method{clustered_graphs}{list}(object, aaties, clust.groups, ...)

\method{clustered_graphs}{egor}(object, clust.groups, ...)

\method{clustered_graphs}{data.frame}(object, aaties, clust.groups,
  egoID = ".egoID", ...)
}
\arguments{
\item{object}{Either an \code{egor} object or a \code{data.frame/ list}
containg alter attributes.}

\item{...}{arguments to be passed to methods}

\item{clust.groups}{A \code{character} naming the \code{factor} variable defining the groups.}

\item{aaties}{\code{data.frame/ list} containg alter-alter relations as a
'global edge list' or as a list of 'edge lists'.
(not needed if \code{object} is an \code{egor} object).}

\item{egoID}{\code{Character}. Name of the variable identifying egos (default: "egoID").}
}
\value{
\code{clustered_graphs} returns a list of graph objects representing
the clustered ego-centered network data;
}
\description{
The idea of clustered graphs is to reduce the complexity of an ego-centered network
graph by visualizing alters in clusters defined by a categorical variable (Lerner et al. 2008).
\code{clustered_graphs()} calculates group sizes, inter and intra group tie
densities and returns these informations in a \code{list} of \code{igraph} objects.
}
\examples{
data("egor32")

# Simplify networks to clustered graphs, stored as igraph objects
graphs <- clustered_graphs(egor32, "country") 

# Visualise
vis_clustered_graphs(graphs, 
                     node.size.multiplier = 5, 
                     edge.width.multiplier = 25,
                     labels = TRUE)
}
\references{
Brandes, U., Lerner, J., Lubbers, M. J., McCarty, C., & Molina,
J. L. (2008). Visual Statistics for Collections of Clustered Graphs. 2008
IEEE Pacific Visualization Symposium, 47-54.
}
\seealso{
\code{\link{vis_clustered_graphs}} for visualizing clustered graphs
}
\keyword{analysis}
\keyword{ego-centered}
\keyword{network}
