% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{create_nc_dims}
\alias{create_nc_dims}
\title{Creates dimensions for a netCDF EFTS data set}
\usage{
create_nc_dims(time_dim_info, str_len = 30, lead_length = 1,
  ensemble_length = 1, num_stations = 1)
}
\arguments{
\item{time_dim_info}{a list with the units and values defining the time dimension of the data set}

\item{str_len}{maximum length of the character for the station identifiers.}

\item{lead_length}{length of the lead time.}

\item{ensemble_length}{number of ensembles, i.e. number of forecasts for each point on the main time axis of the data set}

\item{num_stations}{number of stations}
}
\value{
A list of ncdf4 dimensions
}
\description{
Creates dimensions for a netCDF EFTS data set. Note that end users are unlikely to need to use this function directly, hence this is not exported
}
\seealso{
See
   \code{\link{create_efts}} for examples
}
