% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_dimensions.R
\name{check_is_utc}
\alias{check_is_utc}
\title{Check that a date-time is in the UTC time zone, and return the date time offset 'zero'}
\usage{
check_is_utc(d)
}
\arguments{
\item{d}{an object coercible to a POSIXct}
}
\value{
a character, the time zone offset string '+0000'
}
\description{
Check that a date-time is in the UTC time zone, and return the date time offset 'zero'
}
\examples{
start_time <- ISOdate(year=2010, month=08, day=01, hour = 12, min = 0, sec = 0, tz = 'UTC')
check_is_utc(d=start_time)

}
