% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmm.search.R
\name{hmm.search}
\alias{hmm.search}
\title{Searching for motifs using HMM searches}
\usage{
hmm.search(original.seq, regex.seq, alignment.file = NULL,
  save.alignment = FALSE, mafft.path = NULL, num.threads = 2,
  hmm.path = NULL, seed = 12345)
}
\arguments{
\item{original.seq}{The absolute path for the original six-frame translation FASTA file}

\item{regex.seq}{A list of \code{SeqFastadna} objects resulting from \code{\link{regex.search}}. The HMM profile will be constructed using these sequences}

\item{alignment.file}{(Optional) The absolute path for an alignment file of the sequences to build the hmmer profile from. It's recommended that the alignment file cointains the same sequences than the `regex.seq` files. If the user provides the absolute path, *effectR* won't use MAFFT to align the sequences and will use the alignment for the HMMER searches. If no alignment file is provided, *effectR* will use MAFFT to align the sequences from `regex.seq` and run HMMER.}

\item{save.alignment}{(Optional) Save the alignment in the returning object. The MAFFT alignment will be saved as the first element of the returned object.}

\item{mafft.path}{(Optional) Local path of folder containing the MAFFT binary executable file or the executable file itself. If not specified, then MAFFT must be in the program search path.}

\item{num.threads}{(Optional) Number of threads to be used by MAFFT}

\item{hmm.path}{(Optional) Local path of  folder containing the HMMER binaries.  If not specified, then HMMER executables must be in the program search path.}

\item{seed}{(Optional) The seed to used with HMMER commands. Set this to get the same output each time}
}
\value{
A list of three elements: REGEX candidate effectors, HMM candidate effectors, and HMM results table.
}
\description{
This function uses MAFFT and HMMER to search for sequences with RxLR or CRN motifs using hidden markov models.
}
\details{
\code{hmm.search} uses the results from \code{\link{regex.search}} to search for motifs of interest using Hidden Markov Models after aligning the sequences with MAFFT.
After the multiple sequence alignment is complete, the function constructs a HMM profile using the alignment data. The HMM profile is in the original list of \code{SeqFastadna} objects to obtain the best HMM results with sequences with RxLR or CRN motifs.
}
\note{
If MAFFT/HMMER are not the program search path, the user has to specify the path for the MAFFT and the HMMER executable binaries and specify them in the \code{mafft.path} and \code{hmm.path}
}
\examples{

\dontrun{

fasta.file <- system.file("extdata", "test_infestans.fasta", package = "effectR")
ORF <- seqinr::read.fasta(fasta.file)
REGEX <- regex.search(ORF, motif="RxLR")
candidate.rxlr <- hmm.search(original.seq = fasta.file, regex.seq = REGEX,
 alignment.file=NULL, save.alignment=T)

# To save the alignment:
library(seqinr)
write.fasta(sequences = getSequence(candidate.rxlr$Alignment),
 names = getName(candidate.rxlr$Alignment),
 file.out = "Alin_infestans.fasta", nbchar = 10000)

# To use an alignment file
ALIN <- system.file("extdata", "Alin_infestans.fasta", package = "effectR")
candidate.rxlr <- hmm.search(original.seq = fasta.file, regex.seq = REGEX,
 alignment.file = ALIN)
}
}
\keyword{effector}
\keyword{regex}
