% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srtBayes.R
\name{srtBayes}
\alias{srtBayes}
\title{Analysis of Simple Randomised Education Trials using Bayesian Linear Regression Model with Vague Priors.}
\usage{
srtBayes(
  formula,
  intervention,
  baseln,
  adaptD,
  nsim = 2000,
  data,
  threshold = 1:10/10,
  ...
)
}
\arguments{
\item{formula}{The model to be analysed is of the form y~x1+x2+.... Where y is the outcome variable and Xs are the independent variables.}

\item{intervention}{A string variable specifying the "intervention variable" as appearing in the formula and the data. See example below.}

\item{baseln}{A string variable allowing the user to specify the reference category for intervention variable. When not specified, the first level will be used as a reference.}

\item{adaptD}{As this function uses rstanarm, this term provides the target average proposal acceptance probability during Stan’s adaptation period. Default is NULL.}

\item{nsim}{A number of MCMC iterations per chain. Default is 2000.}

\item{data}{Data frame containing the data to be analysed.}

\item{threshold}{a scalar or vector of pre-specified threshold(s) for estimating Bayesian posterior probability such that the observed effect size is greater than or equal to the threshold(s).}

\item{...}{Additional arguments of \code{\link[rstanarm]{stan_glm}} to be passed to the function.}
}
\value{
S3 object; a list consisting of
\itemize{
\item \code{Beta}: Estimates and credible intervals for the variables specified in the model. Use \code{summary.eefAnalytics} to get Rhat and effective sample size for each estimate.
\item \code{ES}: Conditional Hedges' g effect size and its 95% credible intervals.
\item \code{sigma2}: Residual variance.
\item \code{ProbES}: A matrix of Bayesian posterior probabilities such that the observed effect size is greater than or equal to a pre-specified threshold(s).
\item \code{Model}: A stan_glm object used in ES computation, this object can be used for convergence diagnostic.
\item \code{Unconditional}: A list of unconditional effect sizes, sigma2 and ProbES obtained based on residual variance from the unconditional model (model with only the intercept as a fixed effect).
 }
}
\description{
\code{srtBayes} performs analysis of educational trials under the assumption of independent errors among pupils using Bayesian framework with Stan.
This can also be used with schools as fixed effects.
}
\examples{
if(interactive()){

data(mstData)

########################################################
## Bayesian analysis of cluster randomised trials     ##
########################################################

output <- srtBayes(Posttest~ Intervention+Prettest,
		intervention="Intervention",nsim=2000,data=mstData)

### Fixed effects
beta <- output$Beta
beta

### Effect size
ES1 <- output$ES
ES1

## Covariance matrix
covParm <- output$covParm
covParm

### plot random effects for schools

plot(output)

### plot posterior probability of an effect size to be bigger than a pre-specified threshold

plot(output,group=1)
}
}
