% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textInput3.R
\name{radioButtons3}
\alias{radioButtons3}
\title{Create a side-by-side radioButtons}
\usage{
radioButtons3(inputId, label, choices, bg = NULL, labelwidth = 100,
  inline = FALSE, align = "right", ...)
}
\arguments{
\item{inputId}{The input slot that will be used to access the value.}

\item{label}{Display label for the control, or NULL for no label.}

\item{choices}{List of values to select from}

\item{bg}{The color of text}

\item{labelwidth}{The width of the label in pixel}

\item{inline}{If TRUE, render the choices inline (i.e. horizontally)}

\item{align}{text align of label}

\item{...}{arguments to be passed to radioButtons}
}
\description{
Create a side-by-side radioButtons
}
\examples{
library(shiny)
# Only run examples in interactive R sessions
if (interactive()) {
  ui <- fluidPage(
         label3("Welcome"),
         radioButtons3("mydata", "mydata", choices=c("mtcars","iris")),
         verbatimTextOutput("value")
  )
  server <- function(input, output) {
        output$value <- renderText({ input$mydata })
  }
  shinyApp(ui, server)
}
}
