% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generators.R
\name{generators}
\alias{generators}
\alias{gen}
\alias{genBin}
\alias{genPerm}
\alias{genReal}
\title{Population generators}
\usage{
gen(expr, n)

genBin(n, n.dim)

genPerm(n, n.dim)

genReal(n, n.dim, lower, upper)
}
\arguments{
\item{expr}{[R expression]\cr
Expression to generate a single individual.}

\item{n}{[\code{integer(1)}]\cr
Number of individuals to create.}

\item{n.dim}{[\code{integer(1)}]\cr
Dimension of the decision space.}

\item{lower}{[\code{numeric}]\cr
Vector of minimal values for each parameter of the decision space in case
of float encoding.}

\item{upper}{[\code{numeric}]\cr
Vector of maximal values for each parameter of the decision space in case
of float encoding.}
}
\value{
[\code{list}]
}
\description{
Utility functions to build a set of individuals. The function
\code{gen} expects an R expression and a number n in order to create a list
of n individuals based on the given expression. Functions \code{genBin},
\code{genPerm} and \code{genReal} are shortcuts for initializing populations
of binary strings, permutations or real-valued vectors respectively.
}
