% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_interactions.R
\name{test_interactions}
\alias{test_interactions}
\title{Compare observed interaction strengths in a network to those estimated from
  a null model}
\usage{
test_interactions(nullnet, signif.level = 0.95)
}
\arguments{
\item{nullnet}{An object of class "nullnet" from \code{generate_null_net}}

\item{signif.level}{An optional value specifying the threshold used for
testing for 'significant' deviations from the null model.  Defaults to 0.95}
}
\value{
Returns a data frame listing all possible consumer and resource
  species combinations with the following column headings:
  \describe{
    \item{\code{Consumer}}{The name of the consumer species}
    \item{\code{Resource}}{The name of the resource species}
    \item{\code{Observed}}{The 'strength' of the observed interaction (e.g. total number
      of interactions summed across the individual consumers)}
    \item{\code{Null}}{The mean strength of the interaction across the iterations of the
      null model}
    \item{\code{Lower}}{Lower confidence limit for the interaction strength}
    \item{\code{Upper}}{Upper confidence limit for the interaction strength}
    \item{\code{Test}}{Whether the observed interaction is significantly
      \strong{stronger} than expected under the null model, \strong{weaker}
      or consistent with the null model (\strong{ns})}
    \item{\code{SES}}{The standardised effect size for the interaction}
  }
}
\description{
Takes the result of running a null model with \code{generate_null_net} and
  tests whether the observed interactions between consumer species and
  resource species differ those expected under the null model.
}
\details{
Statistical significance is determined for each consumer-resource
  interaction according to whether the observed interaction strength falls
  outside the confidence limits calculated across the iterations of the null
  model.  Confidence limits are calculated as the 1 -- alpha/2 percentiles from
  the frequency distribution (Manly 2006).

  The observed and expected interactions strengths are also compared by
  calculating the standardised effect size  (Gotelli & McCabe 2002):
  \deqn{(observed link strength - expected link strength) / standard deviation
  of the link strength across the iterations of the null model}

  \code{test_interactions} will issue warnings when:
  \enumerate{
    \item{The number of iterations of the null model was small <100, as
      the confidence intervals are unlikely to be reliable}
    \item{The number of tests >50, due to the increasing risk of Type I
      errors (incorrectly denoting an interaction as significantly different
      from the null model).  Many networks will contain many more than 100
      potential interactions, so the significance of individual interactions
      should be treated with caution.  Some form of false discovery rate
      correction may be valuable (e.g. the local false discovery rate;
      Gotelli & Ulrich 2010).}
  }
}
\examples{
null.1 <- generate_null_net(WelshStreams[, 2:18], WelshStreams.prey[, 2:17],
                            sims = 10, c.samples = WelshStreams[, 1],
                            r.samples = WelshStreams.prey[, 1])
test_interactions(null.1, 0.95)

}
\references{
Gotelli, N.J. & McCabe, D.J. (2002) Species co-occurrence:
   a meta-analysis of J. M. Diamond's assembly rules model. \emph{Ecology},
   \strong{83}, 2091--2096.

   Gotelli, N.J. & Ulrich, W. (2010) The empirical Bayes approach as a tool
   to identify non-random species associations. \emph{Oecologia},
   \strong{162}, 463--477.

   Manly, B.F.J. (2006) \emph{Randomization, Bootstrap and Monte Carlo
   Methods in Biology} (3rd edn). Chapman & Hall, Boca Raton.

   Vaughan, I.P., Gotelli, N.J., Memmott, J., Pearson, C.E., Woodward, G. &
   Symondson, W.O.C. (2018) econullnetr: an R package using null models to
   analyse the structure of ecological networks and identify resource
   selection. \emph{Methods in Ecology and Evolution}, \strong{9}, 728--733.
}
\seealso{
\code{\link{generate_null_net}}, \code{\link{plot_preferences}}
}
