% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proximity.R
\name{proximity}
\alias{proximity}
\title{Proximity}
\usage{
proximity(balassa_index, compute = "both")
}
\arguments{
\item{balassa_index}{(Type: dgCMatrix) the output from
\code{balassa_index()}) or an equivalent arrangement.}

\item{compute}{(Type: character) the proximity to compute. By default this is
\code{"both"} (both proximity matrices) but it can also be \code{"country"}
or \code{"product"}.}
}
\value{
A list of two matrices.
}
\description{
\code{proximity()} computes two matrices that account for the
similarity between pairs of countries and pairs of products.
}
\details{
The current implementation follows
\insertCite{atlas2014}{economiccomplexity} to obtain the likelihood that two
products "p1" and "p2" are exported by the same country and, conversely,
that two countries "c1" and "c2" export the same product.
}
\examples{
pro <- proximity(economiccomplexity_output$balassa_index)

# partial view of proximity matrices
pro$proximity_country[1:5, 1:5]
pro$proximity_product[1:5, 1:5]

}
\references{
For more information see:

\insertRef{atlas2014}{economiccomplexity}

and the references therein.
}
\keyword{functions}
