% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_data.R
\name{save_data}
\alias{save_data}
\title{Save a dataset}
\usage{
save_data(dataset, path, type = ".rds", name = NULL)
}
\arguments{
\item{dataset}{(list) One or more datasets of the structure returned by \code{read_data()}. Name of the \code{dataset} object will become the file name if \code{name} is not used.}

\item{path}{(character) Path to the directory in which \code{dataset} will be written.}

\item{type}{(character) Type of file to save the \code{dataset} as. Default is ".rds" but can also be ".csv". Note: metadata and validation_issues are lost when using ".csv".}

\item{name}{(character) An optional argument for setting the saved file name (for .rds) if you'd like it to be different than \code{dataset}'s object name.}
}
\value{
\item{.rds}{If \code{type = ".rds"}, then an .rds representation of \code{dataset} is returned.}
    \item{.csv}{If \code{type = ".csv"}, then an set of .csv files are written to a sub-directory of \code{path} named after the data package/product ID.}
}
\description{
Save a dataset
}
\note{
Subsequent calls won't overwrite files or directories
}
\examples{
# Create directory for the data
mypath <- paste0(tempdir(), "/data")
dir.create(mypath)

# Save as .rds
save_data(ants_L1, mypath)
dir(mypath)

# Save as .rds with the name "mydata"
save_data(ants_L1, mypath, name = "mydata")
dir(mypath)

# Save as .csv
save_data(ants_L1, mypath, type = ".csv")
dir(mypath)

\dontrun{
# Save multiple datasets
ids <- c("edi.193.5", "edi.303.2", "edi.290.2")
datasets <- lapply(ids, read_data)
save_data(datasets, mypath)
dir(mypath)
}

# Clean up
unlink(mypath, recursive = TRUE)

}
