% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_data.R
\name{validate_data}
\alias{validate_data}
\title{Validate a dataset against the ecocomDP model}
\usage{
validate_data(dataset = NULL, path = NULL)
}
\arguments{
\item{dataset}{(list) A dataset of the structure returned by \code{read_data()}.}

\item{path}{(character) Path to a directory containing ecocomDP tables as files.}
}
\value{
(list) If any checks fail, then a list of validation issues are returned along with a warning. If no issues are found then NULL is returned.
}
\description{
Validate a dataset against the ecocomDP model
}
\details{
Validation checks:
   \itemize{
       \item File names - File names are the ecocomDP table names.
       \item Table presence - Required tables are present.
       \item Column names - Column names of all tables match the model.
       \item Column presence - Required columns are present.
       \item Column classes - Column classes match the model specification.
       \item Datetime format - Date and time formats follow the model specification.
       \item Primary keys - Primary keys of tables are unique.
       \item Composite keys - Composite keys (unique constraints) of each table are unique.
       \item Referential integrity - Foreign keys have a corresponding primary key.
       \item Coordinate format - Values are in decimal degree format.
       \item Coordinate range - Values are within -90 to 90 and -180 to 180.
       \item Elevation - Values are less than Mount Everest (8848 m) and greater than Mariana Trench (-10984 m).
       \item Variable mapping - variable_name is in table_name.
   }
}
\note{
This function is used by ecocomDP creators (to ensure what has been created is valid), maintainers (to improve the quality of archived ecocomDP datasets), and users (to ensure the data being used is free of error).
}
\examples{
# Write a set of ecocomDP tables to file for validation
mydir <- paste0(tempdir(), "/dataset")
dir.create(mydir)
write_tables(
  path = mydir,
  observation = ants_L1$edi.193.5$tables$observation, 
  observation_ancillary = ants_L1$edi.193.5$tables$observation_ancillary,
  location = ants_L1$edi.193.5$tables$location,
  location_ancillary = ants_L1$edi.193.5$tables$location_ancillary,
  taxon = ants_L1$edi.193.5$tables$taxon,
  taxon_ancillary = ants_L1$edi.193.5$tables$taxon_ancillary,
  dataset_summary = ants_L1$edi.193.5$tables$dataset_summary,
  variable_mapping = ants_L1$edi.193.5$tables$variable_mapping)

# Validate
validate_data(path = mydir)

# Clean up
unlink(mydir, recursive = TRUE)

}
